/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.xtea;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.xtea.XteaKey;
import net.runelite.http.api.xtea.XteaRequest;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XteaClient {
    private static final MediaType JSON = MediaType.parse("application/json");
    private static final Logger logger = LoggerFactory.getLogger(XteaClient.class);

    public void submit(XteaRequest xteaRequest) {
    }

    public List<XteaKey> get() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("xtea").build();
        Request request = new Request.Builder().url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            InputStream in = response.body().byteStream();
            List list = (List)RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), new TypeToken<List<XteaKey>>(){}.getType());
            if (response != null) {
                response.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }

    public XteaKey get(int region) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("xtea").addPathSegment(Integer.toString(region)).build();
        Request request = new Request.Builder().url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            InputStream in = response.body().byteStream();
            XteaKey xteaKey = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), XteaKey.class);
            if (response != null) {
                response.close();
            }
            return xteaKey;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }
}

