/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.xp;

import java.io.IOException;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpClient {
    private static final Logger logger = LoggerFactory.getLogger(XpClient.class);

    public void update(final String username) {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("xp").addPathSegment("update").addQueryParameter("username", username).build();
        Request request = new Request.Builder().url(url).build();
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                logger.warn("Error submitting xp track", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                logger.debug("Submitted xp track for {}", (Object)username);
            }
        });
    }
}

