/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.worlds;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.worlds.WorldResult;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldClient {
    private static final Logger logger = LoggerFactory.getLogger(WorldClient.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorldResult lookupWorlds() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("worlds.js").build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.debug("Error looking up worlds: {}", (Object)response);
                WorldResult worldResult = null;
                return worldResult;
            }
            InputStream in = response.body().byteStream();
            WorldResult worldResult = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), WorldResult.class);
            return worldResult;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }
}

