/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.osbuddy;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.osbuddy.OSBGrandExchangeResult;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSBGrandExchangeClient {
    private static final Logger log = LoggerFactory.getLogger(OSBGrandExchangeClient.class);

    public OSBGrandExchangeResult lookupItem(int itemId) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("osb").addPathSegment("ge").addQueryParameter("itemId", Integer.toString(itemId)).build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            if (!response.isSuccessful()) {
                throw new IOException("Error looking up item id: " + response);
            }
            InputStream in = response.body().byteStream();
            OSBGrandExchangeResult oSBGrandExchangeResult = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), OSBGrandExchangeResult.class);
            if (response != null) {
                response.close();
            }
            return oSBGrandExchangeResult;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }
}

