/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.loottracker;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.loottracker.LootRecord;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LootTrackerClient {
    private static final Logger log = LoggerFactory.getLogger(LootTrackerClient.class);
    private static final MediaType JSON = MediaType.parse("application/json");
    private static final Gson GSON = RuneLiteAPI.GSON;
    private final UUID uuid;

    public void submit(LootRecord lootRecord) {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("loottracker").build();
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).post(RequestBody.create(JSON, GSON.toJson(lootRecord))).url(url).build();
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.warn("unable to submit loot", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                log.debug("Submitted loot");
                response.close();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<LootRecord> get() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("loottracker").build();
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.debug("Error looking up loot: {}", (Object)response);
                Collection<LootRecord> collection = null;
                return collection;
            }
            InputStream in = response.body().byteStream();
            Collection collection = (Collection)RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), new TypeToken<List<LootRecord>>(){}.getType());
            return collection;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }

    public void delete(String eventId) {
        HttpUrl.Builder builder = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("loottracker");
        if (eventId != null) {
            builder.addQueryParameter("eventId", eventId);
        }
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).delete().url(builder.build()).build();
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.warn("unable to delete loot", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                log.debug("Deleted loot");
                response.close();
            }
        });
    }

    public LootTrackerClient(UUID uuid) {
        this.uuid = uuid;
    }
}

