/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.item;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.item.ItemPrice;
import net.runelite.http.api.item.ItemStats;
import net.runelite.http.api.item.SearchResult;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemClient {
    private static final Logger logger = LoggerFactory.getLogger(ItemClient.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemPrice lookupItemPrice(int itemId) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("item").addPathSegment("" + itemId).addPathSegment("price").build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.debug("Error looking up item {}: {}", (Object)itemId, (Object)response);
                ItemPrice itemPrice = null;
                return itemPrice;
            }
            InputStream in = response.body().byteStream();
            ItemPrice itemPrice = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), ItemPrice.class);
            return itemPrice;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemPrice[] lookupItemPrice(Integer[] itemIds) throws IOException {
        HttpUrl.Builder urlBuilder = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("item").addPathSegment("price");
        Integer[] integerArray = itemIds;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int itemId = integerArray[i];
            urlBuilder.addQueryParameter("id", String.valueOf(itemId));
        }
        HttpUrl url = urlBuilder.build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.debug("Error looking up items {}: {}", (Object)Arrays.toString((Object[])itemIds), (Object)response);
                ItemPrice[] itemId = null;
                return itemId;
            }
            InputStream in = response.body().byteStream();
            ItemPrice[] itemPriceArray = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), ItemPrice[].class);
            return itemPriceArray;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getIcon(int itemId) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("item").addPathSegment("" + itemId).addPathSegment("icon").build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.debug("Error grabbing icon {}: {}", (Object)itemId, (Object)response);
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            InputStream in = response.body().byteStream();
            Class<ImageIO> clazz = ImageIO.class;
            synchronized (ImageIO.class) {
                BufferedImage bufferedImage = ImageIO.read(in);
                // ** MonitorExit[var6_8] (shouldn't be in output)
                return bufferedImage;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchResult search(String itemName) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("item").addPathSegment("search").addQueryParameter("query", itemName).build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.debug("Error looking up item {}: {}", (Object)itemName, (Object)response);
                SearchResult searchResult = null;
                return searchResult;
            }
            InputStream in = response.body().byteStream();
            SearchResult searchResult = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), SearchResult.class);
            return searchResult;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemPrice[] getPrices() throws IOException {
        HttpUrl.Builder urlBuilder = RuneLiteAPI.getZenyteApi().newBuilder().addPathSegment("runelite").addPathSegment("items").addPathSegment("prices");
        HttpUrl url = urlBuilder.build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.warn("Error looking up prices: {}", (Object)response);
                ItemPrice[] itemPriceArray = null;
                return itemPriceArray;
            }
            InputStream in = response.body().byteStream();
            ItemPrice[] itemPriceArray = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), ItemPrice[].class);
            return itemPriceArray;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Integer, ItemStats> getStats() throws IOException {
        HttpUrl.Builder urlBuilder = RuneLiteAPI.getStaticBase().newBuilder().addPathSegment("item").addPathSegment("stats.ids.min.json");
        HttpUrl url = urlBuilder.build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.warn("Error looking up item stats: {}", (Object)response);
                Map<Integer, ItemStats> map = null;
                return map;
            }
            InputStream in = response.body().byteStream();
            Type typeToken = new TypeToken<Map<Integer, ItemStats>>(){}.getType();
            Map map = (Map)RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), typeToken);
            return map;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }
}

