/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.hiscore;

import java.io.IOException;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.hiscore.HiscoreEndpoint;
import net.runelite.http.api.hiscore.HiscoreResult;
import net.runelite.http.api.hiscore.HiscoreResultBuilder;
import net.runelite.http.api.hiscore.HiscoreSkill;
import net.runelite.http.api.hiscore.SingleHiscoreSkillResult;
import net.runelite.http.api.hiscore.Skill;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiscoreClient {
    private static final Logger log = LoggerFactory.getLogger(HiscoreClient.class);

    public HiscoreResult lookup(String username, HiscoreEndpoint endpoint) throws IOException {
        return this.lookup(username, endpoint.getHiscoreURL());
    }

    public HiscoreResult lookup(String username, HttpUrl endpoint) throws IOException {
        HiscoreResultBuilder resultBuilder = this.lookupUsername(username, endpoint);
        if (resultBuilder == null) {
            return null;
        }
        return resultBuilder.build();
    }

    public HiscoreResult lookup(String username) throws IOException {
        return this.lookup(username, HiscoreEndpoint.NORMAL);
    }

    public SingleHiscoreSkillResult lookup(String username, HiscoreSkill skill, HiscoreEndpoint endpoint) throws IOException {
        HiscoreResultBuilder resultBuilder = this.lookupUsername(username, endpoint.getHiscoreURL());
        if (resultBuilder == null) {
            return null;
        }
        HiscoreResult result = resultBuilder.build();
        Skill requested = result.getSkill(skill);
        SingleHiscoreSkillResult skillResult = new SingleHiscoreSkillResult();
        skillResult.setPlayer(username);
        skillResult.setSkillName(skill.getName());
        skillResult.setSkill(requested);
        return skillResult;
    }

    public SingleHiscoreSkillResult lookup(String username, HiscoreSkill skill) throws IOException {
        return this.lookup(username, skill, HiscoreEndpoint.NORMAL);
    }

    private HiscoreResultBuilder lookupUsername(String username, HttpUrl hiscoreUrl) throws IOException {
        String responseStr;
        HttpUrl url = RuneLiteAPI.getZenyteApi().newBuilder().addPathSegment("hiscores").addPathSegment("user").addPathSegment(username).addPathSegment("runelite").build();
        log.debug("Built URL {}", (Object)url);
        Request okrequest = new Request.Builder().url(url).build();
        try (Response okresponse = RuneLiteAPI.CLIENT.newCall(okrequest).execute();){
            if (!okresponse.isSuccessful()) {
                switch (okresponse.code()) {
                    case 404: {
                        HiscoreResultBuilder hiscoreResultBuilder = null;
                        return hiscoreResultBuilder;
                    }
                }
                throw new IOException("Error retrieving data from Jagex Hiscores: " + okresponse.message());
            }
            responseStr = okresponse.body().string();
        }
        CSVParser parser = CSVParser.parse(responseStr, CSVFormat.DEFAULT);
        HiscoreResultBuilder hiscoreBuilder = new HiscoreResultBuilder();
        hiscoreBuilder.setPlayer(username);
        int count = 0;
        for (CSVRecord record : parser.getRecords()) {
            if (count++ >= HiscoreSkill.values().length) {
                log.warn("Jagex Hiscore API returned unexpected data");
                break;
            }
            int rank = Integer.parseInt(record.get(0));
            int level = Integer.parseInt(record.get(1));
            long experience = -1L;
            if (record.size() == 3) {
                experience = Long.parseLong(record.get(2));
            }
            Skill skill = new Skill(rank, level, experience);
            hiscoreBuilder.setNextSkill(skill);
        }
        return hiscoreBuilder;
    }
}

