/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.feed;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.feed.FeedResult;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedClient {
    private static final Logger logger = LoggerFactory.getLogger(FeedClient.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeedResult lookupFeed() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("feed.js").build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.debug("Error looking up feed: {}", (Object)response);
                FeedResult feedResult = null;
                return feedResult;
            }
            InputStream in = response.body().byteStream();
            FeedResult feedResult = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), FeedResult.class);
            return feedResult;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }
}

