/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.config;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.UUID;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.config.Configuration;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigClient {
    private static final Logger logger = LoggerFactory.getLogger(ConfigClient.class);
    private static final MediaType TEXT_PLAIN = MediaType.parse("text/plain");
    private final UUID uuid;

    public ConfigClient(UUID uuid) {
        this.uuid = uuid;
    }

    public Configuration get() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("config").build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            InputStream in = response.body().byteStream();
            Configuration configuration = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), Configuration.class);
            if (response != null) {
                response.close();
            }
            return configuration;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }

    public void set(final String key, final String value) {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("config").addPathSegment(key).build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().put(RequestBody.create(TEXT_PLAIN, value)).header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                logger.warn("Unable to synchronize configuration item", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                logger.debug("Synchronized configuration value '{}' to '{}'", (Object)key, (Object)value);
            }
        });
    }

    public void unset(final String key) {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("config").addPathSegment(key).build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().delete().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                logger.warn("Unable to unset configuration item", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                logger.debug("Unset configuration value '{}'", (Object)key);
            }
        });
    }
}

