/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.chat;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.chat.Task;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ChatClient {
    public boolean submitKc(String username, String boss, int kc) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("kc").addQueryParameter("name", username).addQueryParameter("boss", boss).addQueryParameter("kc", Integer.toString(kc)).build();
        Request request = new Request.Builder().post(RequestBody.create(null, new byte[0])).url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    public int getKc(String username, String boss) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("kc").addQueryParameter("name", username).addQueryParameter("boss", boss).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unable to look up killcount!");
            }
            int n = Integer.parseInt(response.body().string());
            return n;
        }
    }

    public boolean submitQp(String username, int qp) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("qp").addQueryParameter("name", username).addQueryParameter("qp", Integer.toString(qp)).build();
        Request request = new Request.Builder().post(RequestBody.create(null, new byte[0])).url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    public int getQp(String username) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("qp").addQueryParameter("name", username).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unable to look up quest points!");
            }
            int n = Integer.parseInt(response.body().string());
            return n;
        }
    }

    public boolean submitTask(String username, String task, int amount, int initialAmount, String location) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("task").addQueryParameter("name", username).addQueryParameter("task", task).addQueryParameter("amount", Integer.toString(amount)).addQueryParameter("initialAmount", Integer.toString(initialAmount)).addQueryParameter("location", location).build();
        Request request = new Request.Builder().post(RequestBody.create(null, new byte[0])).url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    public Task getTask(String username) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("task").addQueryParameter("name", username).build();
        Request request = new Request.Builder().url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            if (!response.isSuccessful()) {
                throw new IOException("Unable to look up task!");
            }
            InputStream in = response.body().byteStream();
            Task task = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), Task.class);
            if (response != null) {
                response.close();
            }
            return task;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }

    public boolean submitPb(String username, String boss, int pb) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("pb").addQueryParameter("name", username).addQueryParameter("boss", boss).addQueryParameter("pb", Integer.toString(pb)).build();
        Request request = new Request.Builder().post(RequestBody.create(null, new byte[0])).url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    public int getPb(String username, String boss) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("chat").addPathSegment("pb").addQueryParameter("name", username).addQueryParameter("boss", boss).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unable to look up personal best!");
            }
            int n = Integer.parseInt(response.body().string());
            return n;
        }
    }
}

