/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.account;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.UUID;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.account.OAuthResponse;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountClient {
    private static final Logger logger = LoggerFactory.getLogger(AccountClient.class);
    private UUID uuid;

    public AccountClient() {
    }

    public AccountClient(UUID uuid) {
        this.uuid = uuid;
    }

    public OAuthResponse login() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("account").addPathSegment("login").addQueryParameter("uuid", this.uuid.toString()).build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            InputStream in = response.body().byteStream();
            OAuthResponse oAuthResponse = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), OAuthResponse.class);
            if (response != null) {
                response.close();
            }
            return oAuthResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }

    public void logout() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("account").addPathSegment("logout").build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            logger.debug("Sent logout request");
        }
    }

    public boolean sesssionCheck() {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("account").addPathSegment("session-check").build();
        logger.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException ex) {
                logger.debug("Unable to verify session", ex);
                return true;
            }
        }
    }
}

