/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuneLiteAPI {
    private static final Logger logger = LoggerFactory.getLogger(RuneLiteAPI.class);
    public static final String RUNELITE_AUTH = "RUNELITE-AUTH";
    public static final OkHttpClient CLIENT;
    public static final Gson GSON;
    public static String userAgent;
    private static final String ZENYTE_BASE = "https://api.zenyte.com";
    private static final String BASE = "https://api.runelite.net";
    private static final String WSBASE = "https://api.runelite.net/ws";
    private static final String STATICBASE = "https://static.runelite.net";
    private static final Properties properties;
    private static String version;
    private static int rsVersion;

    public static HttpUrl getApiRoot() {
        return HttpUrl.parse(BASE);
    }

    public static HttpUrl getApiBase() {
        return HttpUrl.parse("https://api.runelite.net/runelite-" + version);
    }

    public static HttpUrl getZenyteApi() {
        return HttpUrl.parse("https://api.zenyte.com/");
    }

    public static HttpUrl getStaticBase() {
        return HttpUrl.parse(STATICBASE);
    }

    public static HttpUrl getWsEndpoint() {
        return HttpUrl.parse(WSBASE);
    }

    public static String getVersion() {
        String version = "1.5.22";
        try {
            Document document = Jsoup.connect("https://raw.githubusercontent.com/runelite/runelite/master/http-api/pom.xml").get();
            version = document.select("parent").select("version").text();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }

    public static void setVersion(String version) {
        RuneLiteAPI.version = version;
    }

    public static int getRsVersion() {
        return rsVersion;
    }

    static {
        GSON = new Gson();
        properties = new Properties();
        try {
            InputStream in = RuneLiteAPI.class.getResourceAsStream("/runelite.properties");
            properties.load(in);
            version = RuneLiteAPI.getVersion();
            rsVersion = Integer.parseInt(properties.getProperty("rs.version"));
            String commit = properties.getProperty("runelite.commit");
            boolean dirty = Boolean.parseBoolean(properties.getProperty("runelite.dirty"));
            userAgent = "RuneLite/" + version + "-" + commit + (dirty ? "+" : "");
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Version string has not been substituted; Re-run maven");
        }
        catch (IOException ex) {
            logger.error(null, ex);
        }
        CLIENT = new OkHttpClient.Builder().pingInterval(30L, TimeUnit.SECONDS).addNetworkInterceptor(new Interceptor(){

            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request userAgentRequest = chain.request().newBuilder().header("User-Agent", userAgent).build();
                return chain.proceed(userAgentRequest);
            }
        }).build();
    }
}

