/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.account.AccountSession;
import net.runelite.client.account.SessionManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.ws.PartyMember;
import net.runelite.client.ws.WSClient;
import net.runelite.http.api.ws.messages.party.Join;
import net.runelite.http.api.ws.messages.party.Part;
import net.runelite.http.api.ws.messages.party.UserJoin;
import net.runelite.http.api.ws.messages.party.UserPart;
import net.runelite.http.api.ws.messages.party.UserSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PartyService {
    private static final Logger log = LoggerFactory.getLogger(PartyService.class);
    public static final int PARTY_MAX = 15;
    private final WSClient wsClient;
    private final SessionManager sessionManager;
    private final EventBus eventBus;
    private final List<PartyMember> members = new ArrayList<PartyMember>();
    private UUID localPartyId;
    private UUID partyId = this.localPartyId = UUID.randomUUID();
    private String username;

    @Inject
    private PartyService(WSClient wsClient, SessionManager sessionManager, EventBus eventBus) {
        this.wsClient = wsClient;
        this.sessionManager = sessionManager;
        this.eventBus = eventBus;
    }

    public void changeParty(UUID newParty) {
        if (this.wsClient.sessionExists()) {
            this.wsClient.send(new Part());
        }
        log.debug("Party change to {}", (Object)newParty);
        this.members.clear();
        this.partyId = newParty;
        if (this.partyId == null) {
            this.partyId = this.localPartyId = UUID.randomUUID();
            if (this.sessionManager.getAccountSession() == null) {
                this.wsClient.changeSession(null);
            }
            this.eventBus.post(new PartyChanged(this.partyId));
            return;
        }
        if (!this.wsClient.sessionExists()) {
            AccountSession accountSession = this.sessionManager.getAccountSession();
            UUID uuid = accountSession != null ? accountSession.getUuid() : UUID.randomUUID();
            this.wsClient.changeSession(uuid);
        }
        this.eventBus.post(new PartyChanged(this.partyId));
        this.wsClient.send(new Join(this.partyId, this.username));
    }

    @Subscribe
    public void onUserJoin(UserJoin message) {
        PartyMember partyMember = new PartyMember(message.getMemberId(), message.getName());
        this.members.add(partyMember);
        PartyMember localMember = this.getLocalMember();
        if (localMember != null && message.getMemberId().equals(localMember.getMemberId())) {
            UserSync userSync = new UserSync();
            userSync.setMemberId(message.getMemberId());
            this.wsClient.send(userSync);
        }
    }

    @Subscribe
    public void onUserPart(UserPart message) {
        this.members.removeIf(member -> member.getMemberId().equals(message.getMemberId()));
    }

    public PartyMember getLocalMember() {
        return this.getMemberByName(this.username);
    }

    public PartyMember getMemberById(UUID id) {
        for (PartyMember member : this.members) {
            if (!id.equals(member.getMemberId())) continue;
            return member;
        }
        return null;
    }

    public PartyMember getMemberByName(String name) {
        for (PartyMember member : this.members) {
            if (!name.equals(member.getName())) continue;
            return member;
        }
        return null;
    }

    public List<PartyMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public boolean isOwner() {
        return this.partyId == null || this.localPartyId.equals(this.partyId);
    }

    public UUID getLocalPartyId() {
        return this.localPartyId;
    }

    public UUID getPartyId() {
        return this.partyId;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

