/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class Text {
    private static final Pattern TAG_REGEXP = Pattern.compile("<[^>]*>");
    private static final Splitter COMMA_SPLITTER = Splitter.on(",").omitEmptyStrings().trimResults();
    private static final Joiner COMMA_JOINER = Joiner.on(",").skipNulls();

    public static List<String> fromCSV(String input) {
        return COMMA_SPLITTER.splitToList(input);
    }

    public static String toCSV(Collection<String> input) {
        return COMMA_JOINER.join(input);
    }

    public static String removeTags(String str) {
        return TAG_REGEXP.matcher(str).replaceAll("");
    }

    public static String standardize(String str) {
        return Text.removeTags(str).replace('\u00a0', ' ').trim().toLowerCase();
    }

    public static String toJagexName(String str) {
        return CharMatcher.ascii().retainFrom(str.replace('\u00a0', ' ')).replaceAll("[_-]+", " ").trim();
    }

    public static String sanitizeMultilineText(String str) {
        return Text.removeTags(str.replaceAll("-<br>", "-").replaceAll("<br>", " ").replaceAll("[ ]+", " "));
    }

    public static String escapeJagex(String str) {
        StringBuilder out = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                out.append("<lt>");
                continue;
            }
            if (c == '>') {
                out.append("<gt>");
                continue;
            }
            if (c == '\n') {
                out.append("<br>");
                continue;
            }
            if (c == '\r') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String sanitize(String name) {
        String cleaned = name.contains("<img") ? name.substring(name.lastIndexOf(62) + 1) : name;
        return cleaned.replace('\u00a0', ' ');
    }
}

