/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import com.google.common.base.Strings;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Singleton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LinkBrowser {
    private static final Logger log = LoggerFactory.getLogger(LinkBrowser.class);
    private static boolean shouldAttemptXdg = OSType.getOSType() == OSType.Linux;

    public static boolean browse(String url) {
        if (Strings.isNullOrEmpty(url)) {
            return false;
        }
        if (LinkBrowser.attemptDesktopBrowse(url)) {
            log.debug("Opened browser through Desktop#browse to {}", (Object)url);
            return true;
        }
        if (shouldAttemptXdg && LinkBrowser.attemptXdgOpen(url)) {
            log.debug("Opened browser through xdg-open to {}", (Object)url);
            return true;
        }
        LinkBrowser.showMessageBox("Unable to open link. Press 'OK' and link will be copied to your clipboard.", url);
        return false;
    }

    private static boolean attemptXdgOpen(String url) {
        try {
            Process exec = Runtime.getRuntime().exec(new String[]{"xdg-open", url});
            exec.waitFor();
            int ret = exec.exitValue();
            if (ret == 0) {
                return true;
            }
            log.warn("xdg-open {} returned with error code {}", (Object)url, (Object)ret);
            return false;
        }
        catch (IOException ex) {
            shouldAttemptXdg = false;
            return false;
        }
        catch (InterruptedException ex) {
            log.warn("Interrupted while waiting for xdg-open {} to execute", (Object)url);
            return false;
        }
    }

    private static boolean attemptDesktopBrowse(String url) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(new URI(url));
            return true;
        }
        catch (IOException | URISyntaxException ex) {
            log.warn("Failed to open Desktop#browser {}", (Object)url, (Object)ex);
            return false;
        }
    }

    private static void showMessageBox(String message, String data) {
        SwingUtilities.invokeLater(() -> {
            int result = JOptionPane.showConfirmDialog(null, message, "Message", 2);
            if (result == 0) {
                StringSelection stringSelection = new StringSelection(data);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            }
        });
    }
}

