/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.worldmap;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;

@Singleton
public class WorldMapOverlayMouseListener
extends MouseAdapter {
    private final Client client;
    private final WorldMapPointManager worldMapPointManager;
    private WorldMapPoint tooltipPoint = null;

    @Inject
    private WorldMapOverlayMouseListener(Client client2, WorldMapPointManager worldMapPointManager) {
        this.client = client2;
        this.worldMapPointManager = worldMapPointManager;
    }

    @Override
    public MouseEvent mousePressed(MouseEvent e) {
        List<WorldMapPoint> worldMapPoints = this.worldMapPointManager.getWorldMapPoints();
        if (SwingUtilities.isLeftMouseButton(e) && !worldMapPoints.isEmpty()) {
            Point mousePos = this.client.getMouseCanvasPosition();
            for (WorldMapPoint worldMapPoint : worldMapPoints) {
                Rectangle clickbox = worldMapPoint.getClickbox();
                if (clickbox == null || !clickbox.contains(mousePos.getX(), mousePos.getY())) continue;
                if (worldMapPoint.isJumpOnClick()) {
                    WorldPoint target = worldMapPoint.getWorldPoint();
                    RenderOverview renderOverview = this.client.getRenderOverview();
                    renderOverview.setWorldMapPositionTarget(target);
                }
                return worldMapPoint.onClick(e);
            }
        }
        return e;
    }

    @Override
    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        List<WorldMapPoint> worldMapPoints = this.worldMapPointManager.getWorldMapPoints();
        if (worldMapPoints.isEmpty()) {
            return mouseEvent;
        }
        Point mousePos = this.client.getMouseCanvasPosition();
        Widget view = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (view == null) {
            return mouseEvent;
        }
        Rectangle worldMapDisplay = view.getBounds();
        if (worldMapDisplay == null || !worldMapDisplay.contains(mousePos.getX(), mousePos.getY())) {
            if (this.tooltipPoint != null) {
                this.tooltipPoint.setTooltipVisible(false);
                this.tooltipPoint = null;
                Widget rsTooltip = this.client.getWidget(WidgetInfo.WORLD_MAP_TOOLTIP);
                if (rsTooltip != null) {
                    rsTooltip.setHidden(false);
                }
            }
            return mouseEvent;
        }
        if (this.tooltipPoint != null) {
            if (this.tooltipPoint.getClickbox() != null && this.tooltipPoint.getClickbox().contains(mousePos.getX(), mousePos.getY())) {
                return mouseEvent;
            }
            this.tooltipPoint.setTooltipVisible(false);
            this.tooltipPoint = null;
            Widget rsTooltip = this.client.getWidget(WidgetInfo.WORLD_MAP_TOOLTIP);
            if (rsTooltip != null) {
                rsTooltip.setHidden(false);
            }
        }
        for (WorldMapPoint worldMapPoint : this.worldMapPointManager.getWorldMapPoints()) {
            if (worldMapPoint.getClickbox() == null || !worldMapPoint.getClickbox().contains(mousePos.getX(), mousePos.getY()) || worldMapPoint.getTooltip() == null) continue;
            worldMapPoint.setTooltipVisible(true);
            this.tooltipPoint = worldMapPoint;
            Widget rsTooltip = this.client.getWidget(WidgetInfo.WORLD_MAP_TOOLTIP);
            if (rsTooltip != null) {
                rsTooltip.setHidden(true);
            }
            return mouseEvent;
        }
        return mouseEvent;
    }
}

