/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.worldmap;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.input.MouseManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlayMouseListener;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;

@Singleton
public class WorldMapOverlay
extends Overlay {
    private static final int TOOLTIP_OFFSET_HEIGHT = 25;
    private static final int TOOLTIP_OFFSET_WIDTH = 5;
    private static final int TOOLTIP_PADDING_HEIGHT = 1;
    private static final int TOOLTIP_PADDING_WIDTH = 2;
    private final WorldMapPointManager worldMapPointManager;
    private final Client client;

    @Inject
    private WorldMapOverlay(Client client2, WorldMapPointManager worldMapPointManager, MouseManager mouseManager, WorldMapOverlayMouseListener worldMapOverlayMouseListener) {
        this.client = client2;
        this.worldMapPointManager = worldMapPointManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ABOVE_MAP);
        mouseManager.registerMouseListener(worldMapOverlayMouseListener);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        List<WorldMapPoint> points = this.worldMapPointManager.getWorldMapPoints();
        if (points.isEmpty()) {
            return null;
        }
        Widget widget = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (widget == null) {
            return null;
        }
        Rectangle worldMapRectangle = widget.getBounds();
        Area mapViewArea = this.getWorldMapClipArea(worldMapRectangle);
        Rectangle canvasBounds = this.client.getCanvas().getBounds();
        canvasBounds.setLocation(0, 0);
        Area canvasViewArea = this.getWorldMapClipArea(canvasBounds);
        Area currentClip = null;
        WorldMapPoint tooltipPoint = null;
        for (WorldMapPoint worldPoint : points) {
            BufferedImage image = worldPoint.getImage();
            WorldPoint point = worldPoint.getWorldPoint();
            if (image == null || point == null) continue;
            Point drawPoint = this.mapWorldPointToGraphicsPoint(point);
            if (drawPoint == null) {
                worldPoint.setClickbox(null);
                continue;
            }
            if (worldPoint.isSnapToEdge() && canvasViewArea != currentClip) {
                graphics.setClip(canvasViewArea);
                currentClip = canvasViewArea;
            } else if (!worldPoint.isSnapToEdge() && mapViewArea != currentClip) {
                graphics.setClip(mapViewArea);
                currentClip = mapViewArea;
            }
            if (worldPoint.isSnapToEdge()) {
                if (worldMapRectangle.contains(drawPoint.getX(), drawPoint.getY())) {
                    if (worldPoint.isCurrentlyEdgeSnapped()) {
                        worldPoint.setCurrentlyEdgeSnapped(false);
                        worldPoint.onEdgeUnsnap();
                    }
                } else {
                    drawPoint = this.clipToRectangle(drawPoint, worldMapRectangle);
                    if (!worldPoint.isCurrentlyEdgeSnapped()) {
                        worldPoint.setCurrentlyEdgeSnapped(true);
                        worldPoint.onEdgeSnap();
                    }
                }
            }
            int drawX = drawPoint.getX();
            int drawY = drawPoint.getY();
            if (worldPoint.getImagePoint() == null) {
                drawX -= image.getWidth() / 2;
                drawY -= image.getHeight() / 2;
            } else {
                drawX -= worldPoint.getImagePoint().getX();
                drawY -= worldPoint.getImagePoint().getY();
            }
            graphics.drawImage((Image)image, drawX, drawY, null);
            Rectangle clickbox = new Rectangle(drawX, drawY, image.getWidth(), image.getHeight());
            worldPoint.setClickbox(clickbox);
            if (!worldPoint.isTooltipVisible()) continue;
            tooltipPoint = worldPoint;
        }
        if (tooltipPoint != null) {
            this.drawTooltip(graphics, tooltipPoint);
        }
        return null;
    }

    public Point mapWorldPointToGraphicsPoint(WorldPoint worldPoint) {
        RenderOverview ro = this.client.getRenderOverview();
        if (!ro.getWorldMapData().surfaceContainsPosition(worldPoint.getX(), worldPoint.getY())) {
            return null;
        }
        Float pixelsPerTile = Float.valueOf(ro.getWorldMapZoom());
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map != null) {
            Rectangle worldMapRect = map.getBounds();
            int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile.floatValue());
            int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile.floatValue());
            Point worldMapPosition = ro.getWorldMapPosition();
            int yTileMax = worldMapPosition.getY() - heightInTiles / 2;
            int yTileOffset = (yTileMax - worldPoint.getY() - 1) * -1;
            int xTileOffset = worldPoint.getX() + widthInTiles / 2 - worldMapPosition.getX();
            int xGraphDiff = (int)((float)xTileOffset * pixelsPerTile.floatValue());
            int yGraphDiff = (int)((float)yTileOffset * pixelsPerTile.floatValue());
            yGraphDiff = (int)((double)yGraphDiff - ((double)pixelsPerTile.floatValue() - Math.ceil(pixelsPerTile.floatValue() / 2.0f)));
            xGraphDiff = (int)((double)xGraphDiff + ((double)pixelsPerTile.floatValue() - Math.ceil(pixelsPerTile.floatValue() / 2.0f)));
            yGraphDiff = worldMapRect.height - yGraphDiff;
            return new Point(xGraphDiff += (int)worldMapRect.getX(), yGraphDiff += (int)worldMapRect.getY());
        }
        return null;
    }

    private Area getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }

    private void drawTooltip(Graphics2D graphics, WorldMapPoint worldPoint) {
        String tooltip = worldPoint.getTooltip();
        Point drawPoint = this.mapWorldPointToGraphicsPoint(worldPoint.getWorldPoint());
        if (tooltip == null || tooltip.length() <= 0 || drawPoint == null) {
            return;
        }
        drawPoint = new Point(drawPoint.getX() + 5, drawPoint.getY() + 25);
        graphics.setClip(this.client.getCanvas().getBounds());
        graphics.setColor(JagexColors.TOOLTIP_BACKGROUND);
        graphics.setFont(FontManager.getRunescapeFont());
        FontMetrics fm = graphics.getFontMetrics();
        int width = fm.stringWidth(tooltip);
        int height = fm.getHeight();
        Rectangle tooltipRect = new Rectangle(drawPoint.getX() - 2, drawPoint.getY() - 1, width + 4, height + 2);
        graphics.fillRect((int)tooltipRect.getX(), (int)tooltipRect.getY(), (int)tooltipRect.getWidth(), (int)tooltipRect.getHeight());
        graphics.setColor(JagexColors.TOOLTIP_BORDER);
        graphics.drawRect((int)tooltipRect.getX(), (int)tooltipRect.getY(), (int)tooltipRect.getWidth(), (int)tooltipRect.getHeight());
        graphics.setColor(JagexColors.TOOLTIP_TEXT);
        graphics.drawString(tooltip, drawPoint.getX(), drawPoint.getY() + height);
    }

    private Point clipToRectangle(Point drawPoint, Rectangle mapDisplayRectangle) {
        int clippedX = drawPoint.getX();
        if ((double)drawPoint.getX() < mapDisplayRectangle.getX()) {
            clippedX = (int)mapDisplayRectangle.getX();
        }
        if ((double)drawPoint.getX() > mapDisplayRectangle.getX() + mapDisplayRectangle.getWidth()) {
            clippedX = (int)(mapDisplayRectangle.getX() + mapDisplayRectangle.getWidth());
        }
        int clippedY = drawPoint.getY();
        if ((double)drawPoint.getY() < mapDisplayRectangle.getY()) {
            clippedY = (int)mapDisplayRectangle.getY();
        }
        if ((double)drawPoint.getY() > mapDisplayRectangle.getY() + mapDisplayRectangle.getHeight()) {
            clippedY = (int)(mapDisplayRectangle.getY() + mapDisplayRectangle.getHeight());
        }
        return new Point(clippedX, clippedY);
    }
}

