/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.tooltip;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.TooltipComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

@Singleton
public class TooltipOverlay
extends Overlay {
    private static final int OFFSET = 24;
    private static final int PADDING = 2;
    private final TooltipManager tooltipManager;
    private final Client client;

    @Inject
    private TooltipOverlay(Client client2, TooltipManager tooltipManager) {
        this.client = client2;
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.TOOLTIP);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        List<Tooltip> tooltips = this.tooltipManager.getTooltips();
        if (tooltips.isEmpty()) {
            return null;
        }
        Rectangle clientCanvasBounds = new Rectangle(this.client.getRealDimensions());
        Point mouseCanvasPosition = this.client.getMouseCanvasPosition();
        java.awt.Point mousePosition = new java.awt.Point(mouseCanvasPosition.getX(), mouseCanvasPosition.getY() + 24);
        Rectangle bounds = new Rectangle(this.getBounds());
        bounds.setLocation(mousePosition);
        if (!clientCanvasBounds.contains(bounds)) {
            int clientX = (int)clientCanvasBounds.getMaxX();
            int clientY = (int)clientCanvasBounds.getMaxY();
            int boundsX = (int)bounds.getMaxX();
            int boundsY = (int)bounds.getMaxY();
            if (boundsY > clientY) {
                graphics.translate(0, -bounds.height - 24);
            }
            if (boundsX > clientX) {
                graphics.translate(-bounds.width + clientCanvasBounds.width - bounds.x, 0);
            }
        }
        Rectangle newBounds = new Rectangle(-1, -1, 0, 0);
        for (Tooltip tooltip : tooltips) {
            TooltipComponent tooltipComponent = new TooltipComponent();
            tooltipComponent.setModIcons(this.client.getModIcons());
            tooltipComponent.setText(tooltip.getText());
            if (newBounds.contains(mousePosition)) {
                mousePosition.move(mouseCanvasPosition.getX(), mouseCanvasPosition.getY() + 24 + newBounds.height);
            }
            tooltipComponent.setPosition(mousePosition);
            Dimension dimension = tooltipComponent.render(graphics);
            newBounds.x = newBounds.x != -1 ? Math.min(newBounds.x, mousePosition.x) : mousePosition.x;
            newBounds.y = newBounds.y != -1 ? Math.min(newBounds.y, mousePosition.y) : mousePosition.y;
            newBounds.height += dimension.height + 2;
            newBounds.width = Math.max(newBounds.width, dimension.width);
        }
        this.tooltipManager.clear();
        return newBounds.getSize();
    }
}

