/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.infobox;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;

public class Timer
extends InfoBox {
    private final Instant startTime;
    private final Instant endTime;
    private final Duration duration;

    public Timer(long period, ChronoUnit unit, BufferedImage image, Plugin plugin) {
        super(image, plugin);
        Preconditions.checkArgument(period > 0L, "negative period!");
        this.startTime = Instant.now();
        this.duration = Duration.of(period, unit);
        this.endTime = this.startTime.plus(this.duration);
    }

    @Override
    public String getText() {
        Duration timeLeft = Duration.between(Instant.now(), this.endTime);
        int seconds = (int)(timeLeft.toMillis() / 1000L);
        int minutes = seconds % 3600 / 60;
        int secs = seconds % 60;
        return String.format("%d:%02d", minutes, secs);
    }

    @Override
    public Color getTextColor() {
        Duration timeLeft = Duration.between(Instant.now(), this.endTime);
        if ((double)timeLeft.getSeconds() < (double)this.duration.getSeconds() * 0.1) {
            return Color.RED.brighter();
        }
        return Color.WHITE;
    }

    @Override
    public boolean render() {
        Duration timeLeft = Duration.between(Instant.now(), this.endTime);
        return !timeLeft.isNegative();
    }

    @Override
    public boolean cull() {
        Duration timeLeft = Duration.between(Instant.now(), this.endTime);
        return timeLeft.isZero() || timeLeft.isNegative();
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String toString() {
        return "Timer(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", duration=" + this.getDuration() + ")";
    }
}

