/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.infobox;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.InfoBoxComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

@Singleton
public class InfoBoxOverlay
extends Overlay {
    private final PanelComponent panelComponent = new PanelComponent();
    private final InfoBoxManager infoboxManager;
    private final TooltipManager tooltipManager;
    private final Client client;
    private final RuneLiteConfig config;

    @Inject
    private InfoBoxOverlay(InfoBoxManager infoboxManager, TooltipManager tooltipManager, Client client2, RuneLiteConfig config) {
        this.tooltipManager = tooltipManager;
        this.infoboxManager = infoboxManager;
        this.client = client2;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.panelComponent.setBackgroundColor(null);
        this.panelComponent.setBorder(new Rectangle());
        this.panelComponent.setGap(new Point(1, 1));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        List<InfoBox> infoBoxes = this.infoboxManager.getInfoBoxes();
        if (infoBoxes.isEmpty()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        this.panelComponent.setWrapping(this.config.infoBoxWrap());
        this.panelComponent.setOrientation(this.config.infoBoxVertical() ? PanelComponent.Orientation.VERTICAL : PanelComponent.Orientation.HORIZONTAL);
        this.panelComponent.setPreferredSize(new Dimension(this.config.infoBoxSize(), this.config.infoBoxSize()));
        for (InfoBox box : infoBoxes) {
            if (!box.render()) continue;
            String text = box.getText();
            Color color = box.getTextColor();
            InfoBoxComponent infoBoxComponent = new InfoBoxComponent();
            infoBoxComponent.setText(text);
            if (color != null) {
                infoBoxComponent.setColor(color);
            }
            infoBoxComponent.setImage(box.getScaledImage());
            infoBoxComponent.setTooltip(box.getTooltip());
            this.panelComponent.getChildren().add(infoBoxComponent);
        }
        Dimension dimension = this.panelComponent.render(graphics);
        Point mouse = new Point(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY());
        for (LayoutableRenderableEntity child : this.panelComponent.getChildren()) {
            InfoBoxComponent component;
            if (!(child instanceof InfoBoxComponent) || Strings.isNullOrEmpty((component = (InfoBoxComponent)child).getTooltip())) continue;
            Rectangle intersectionRectangle = new Rectangle(component.getBounds());
            intersectionRectangle.translate(this.getBounds().x, this.getBounds().y);
            if (!intersectionRectangle.contains(mouse)) continue;
            this.tooltipManager.add(new Tooltip(component.getTooltip()));
        }
        return dimension;
    }
}

