/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.infobox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.events.ConfigChanged;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InfoBoxManager {
    private static final Logger log = LoggerFactory.getLogger(InfoBoxManager.class);
    private final List<InfoBox> infoBoxes = new ArrayList<InfoBox>();
    private final RuneLiteConfig runeLiteConfig;

    @Inject
    private InfoBoxManager(RuneLiteConfig runeLiteConfig) {
        this.runeLiteConfig = runeLiteConfig;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("runelite") && event.getKey().equals("infoBoxSize")) {
            this.infoBoxes.forEach(this::updateInfoBoxImage);
        }
    }

    public void addInfoBox(InfoBox infoBox) {
        Preconditions.checkNotNull(infoBox);
        log.debug("Adding InfoBox {}", (Object)infoBox);
        this.updateInfoBoxImage(infoBox);
        this.infoBoxes.add(infoBox);
        this.refreshInfoBoxes();
    }

    public void removeInfoBox(InfoBox infoBox) {
        if (this.infoBoxes.remove(infoBox)) {
            log.debug("Removed InfoBox {}", (Object)infoBox);
            this.refreshInfoBoxes();
        }
    }

    public void removeIf(Predicate<InfoBox> filter) {
        if (this.infoBoxes.removeIf(filter)) {
            log.debug("Removed InfoBoxes for filter {}", (Object)filter);
            this.refreshInfoBoxes();
        }
    }

    public List<InfoBox> getInfoBoxes() {
        return Collections.unmodifiableList(this.infoBoxes);
    }

    public void cull() {
        boolean culled = false;
        Iterator<InfoBox> it = this.infoBoxes.iterator();
        while (it.hasNext()) {
            InfoBox box = it.next();
            if (!box.cull()) continue;
            log.debug("Culling InfoBox {}", (Object)box);
            it.remove();
            culled = true;
        }
        if (culled) {
            this.refreshInfoBoxes();
        }
    }

    private void updateInfoBoxImage(InfoBox infoBox) {
        Image image;
        if (infoBox.getImage() == null) {
            return;
        }
        Image resultImage = image = infoBox.getImage();
        double width = image.getWidth(null);
        double height = image.getHeight(null);
        double size = Math.max(2, this.runeLiteConfig.infoBoxSize());
        if (size < width || size < height) {
            double scalex = size / width;
            double scaley = size / height;
            if (scalex == 1.0 && scaley == 1.0) {
                return;
            }
            double scale = Math.min(scalex, scaley);
            int newWidth = (int)(width * scale);
            int newHeight = (int)(height * scale);
            BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 2);
            Graphics2D g = scaledImage.createGraphics();
            g.drawImage(image, 0, 0, newWidth, newHeight, null);
            g.dispose();
            resultImage = scaledImage;
        }
        infoBox.setScaledImage(resultImage);
    }

    private void refreshInfoBoxes() {
        this.infoBoxes.sort((b1, b2) -> ComparisonChain.start().compare((Comparable<?>)((Object)b1.getPriority()), (Comparable<?>)((Object)b2.getPriority())).compare((Comparable<?>)((Object)b1.getPlugin().getClass().getAnnotation(PluginDescriptor.class).name()), (Comparable<?>)((Object)b2.getPlugin().getClass().getAnnotation(PluginDescriptor.class).name())).result());
    }
}

