/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.runelite.client.ui.overlay.components.BackgroundComponent;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public class PanelComponent
implements LayoutableRenderableEntity {
    private final Rectangle bounds = new Rectangle();
    private Point preferredLocation = new Point();
    private Dimension preferredSize = new Dimension(129, 0);
    @Nullable
    private Color backgroundColor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
    private final List<LayoutableRenderableEntity> children = new ArrayList<LayoutableRenderableEntity>();
    private Orientation orientation = Orientation.VERTICAL;
    private int wrapping = -1;
    private Rectangle border = new Rectangle(4, 4, 4, 4);
    private Point gap = new Point(0, 0);
    private final Dimension childDimensions = new Dimension();

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.children.isEmpty()) {
            return null;
        }
        Dimension dimension = new Dimension(this.border.x + this.childDimensions.width + this.border.width, this.border.y + this.childDimensions.height + this.border.height);
        if (this.backgroundColor != null) {
            BackgroundComponent backgroundComponent = new BackgroundComponent();
            backgroundComponent.setRectangle(new Rectangle(this.preferredLocation, dimension));
            backgroundComponent.setBackgroundColor(this.backgroundColor);
            backgroundComponent.render(graphics);
        }
        int baseX = this.preferredLocation.x + this.border.x;
        int baseY = this.preferredLocation.y + this.border.y;
        int width = 0;
        int height = 0;
        int x = baseX;
        int y = baseY;
        Dimension childPreferredSize = new Dimension(this.preferredSize.width - this.border.x - this.border.width, this.preferredSize.height - this.border.y - this.border.height);
        int totalHeight = 0;
        int totalWidth = 0;
        block8: for (int i = 0; i < this.children.size(); ++i) {
            LayoutableRenderableEntity child = this.children.get(i);
            child.setPreferredLocation(new Point(x, y));
            child.setPreferredSize(childPreferredSize);
            Dimension childDimension = child.render(graphics);
            switch (this.orientation) {
                case VERTICAL: {
                    y = baseY + (height += childDimension.height + this.gap.y);
                    width = Math.max(width, childDimension.width);
                    break;
                }
                case HORIZONTAL: {
                    x = baseX + (width += childDimension.width + this.gap.x);
                    height = Math.max(height, childDimension.height);
                }
            }
            totalWidth = Math.max(totalWidth, width);
            totalHeight = Math.max(totalHeight, height);
            if (this.wrapping <= 0 || i >= this.children.size() - 1 || (i + 1) % this.wrapping != 0) continue;
            switch (this.orientation) {
                case VERTICAL: {
                    height = 0;
                    y = baseY;
                    int diff = childDimension.width + this.gap.x;
                    x += diff;
                    width += diff;
                    continue block8;
                }
                case HORIZONTAL: {
                    width = 0;
                    x = baseX;
                    int diff = childDimension.height + this.gap.y;
                    y += diff;
                    height += diff;
                    continue block8;
                }
            }
        }
        this.childDimensions.setSize(totalWidth -= this.gap.x, totalHeight -= this.gap.y);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void setBackgroundColor(@Nullable Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public List<LayoutableRenderableEntity> getChildren() {
        return this.children;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public void setWrapping(int wrapping) {
        this.wrapping = wrapping;
    }

    public void setBorder(Rectangle border) {
        this.border = border;
    }

    public void setGap(Point gap) {
        this.gap = gap;
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

