/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.components;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;

public class LineComponent
implements LayoutableRenderableEntity {
    private String left;
    private String right;
    private Color leftColor;
    private Color rightColor;
    private Point preferredLocation;
    private Dimension preferredSize;
    private final Rectangle bounds;

    @Override
    public Dimension render(Graphics2D graphics) {
        int rightFullWidth;
        String left = MoreObjects.firstNonNull(this.left, "");
        String right = MoreObjects.firstNonNull(this.right, "");
        FontMetrics metrics = graphics.getFontMetrics();
        int baseX = this.preferredLocation.x;
        int baseY = this.preferredLocation.y + metrics.getHeight();
        int x = baseX;
        int y = baseY;
        int leftFullWidth = LineComponent.getLineWidth(left, metrics);
        if (this.preferredSize.width < leftFullWidth + (rightFullWidth = LineComponent.getLineWidth(right, metrics))) {
            int leftSmallWidth = this.preferredSize.width;
            int rightSmallWidth = 0;
            if (!Strings.isNullOrEmpty(right)) {
                rightSmallWidth = this.preferredSize.width / 3;
                leftSmallWidth -= rightSmallWidth;
            }
            String[] leftSplitLines = LineComponent.lineBreakText(left, leftSmallWidth, metrics);
            String[] rightSplitLines = LineComponent.lineBreakText(right, rightSmallWidth, metrics);
            int lineCount = Math.max(leftSplitLines.length, rightSplitLines.length);
            for (int i = 0; i < lineCount; ++i) {
                String leftText = "";
                String rightText = "";
                if (i < leftSplitLines.length) {
                    leftText = leftSplitLines[i];
                }
                if (i < rightSplitLines.length) {
                    rightText = rightSplitLines[i];
                }
                TextComponent leftLineComponent = new TextComponent();
                leftLineComponent.setPosition(new Point(x, y));
                leftLineComponent.setText(leftText);
                leftLineComponent.setColor(this.leftColor);
                leftLineComponent.render(graphics);
                TextComponent rightLineComponent = new TextComponent();
                rightLineComponent.setPosition(new Point(x + leftSmallWidth + rightSmallWidth - LineComponent.getLineWidth(rightText, metrics), y));
                rightLineComponent.setText(rightText);
                rightLineComponent.setColor(this.rightColor);
                rightLineComponent.render(graphics);
                y += metrics.getHeight();
            }
            Dimension dimension = new Dimension(this.preferredSize.width, y - baseY);
            this.bounds.setLocation(this.preferredLocation);
            this.bounds.setSize(dimension);
            return dimension;
        }
        TextComponent leftLineComponent = new TextComponent();
        leftLineComponent.setPosition(new Point(x, y));
        leftLineComponent.setText(left);
        leftLineComponent.setColor(this.leftColor);
        leftLineComponent.render(graphics);
        TextComponent rightLineComponent = new TextComponent();
        rightLineComponent.setPosition(new Point(x + this.preferredSize.width - LineComponent.getLineWidth(right, metrics), y));
        rightLineComponent.setText(right);
        rightLineComponent.setColor(this.rightColor);
        rightLineComponent.render(graphics);
        Dimension dimension = new Dimension(this.preferredSize.width, (y += metrics.getHeight()) - baseY);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    private static int getLineWidth(String line, FontMetrics metrics) {
        return metrics.stringWidth(TextComponent.textWithoutColTags(line));
    }

    private static String[] lineBreakText(String text, int maxWidth, FontMetrics metrics) {
        String[] words = text.split(" ");
        if (words.length == 0) {
            return new String[0];
        }
        StringBuilder wrapped = new StringBuilder(words[0]);
        int spaceLeft = maxWidth - metrics.stringWidth(wrapped.toString());
        for (int i = 1; i < words.length; ++i) {
            int spaceWidth;
            String word = words[i];
            int wordLen = metrics.stringWidth(word);
            if (wordLen + (spaceWidth = metrics.stringWidth(" ")) > spaceLeft) {
                wrapped.append("\n").append(word);
                spaceLeft = maxWidth - wordLen;
                continue;
            }
            wrapped.append(" ").append(word);
            spaceLeft -= spaceWidth + wordLen;
        }
        return wrapped.toString().split("\n");
    }

    private static Color $default$leftColor() {
        return Color.WHITE;
    }

    private static Color $default$rightColor() {
        return Color.WHITE;
    }

    private static Point $default$preferredLocation() {
        return new Point();
    }

    private static Dimension $default$preferredSize() {
        return new Dimension(129, 0);
    }

    private static Rectangle $default$bounds() {
        return new Rectangle();
    }

    LineComponent(String left, String right, Color leftColor, Color rightColor, Point preferredLocation, Dimension preferredSize, Rectangle bounds) {
        this.left = left;
        this.right = right;
        this.leftColor = leftColor;
        this.rightColor = rightColor;
        this.preferredLocation = preferredLocation;
        this.preferredSize = preferredSize;
        this.bounds = bounds;
    }

    public static LineComponentBuilder builder() {
        return new LineComponentBuilder();
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public void setLeftColor(Color leftColor) {
        this.leftColor = leftColor;
    }

    public void setRightColor(Color rightColor) {
        this.rightColor = rightColor;
    }

    @Override
    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public static class LineComponentBuilder {
        private String left;
        private String right;
        private boolean leftColor$set;
        private Color leftColor$value;
        private boolean rightColor$set;
        private Color rightColor$value;
        private boolean preferredLocation$set;
        private Point preferredLocation$value;
        private boolean preferredSize$set;
        private Dimension preferredSize$value;
        private boolean bounds$set;
        private Rectangle bounds$value;

        LineComponentBuilder() {
        }

        public LineComponentBuilder left(String left) {
            this.left = left;
            return this;
        }

        public LineComponentBuilder right(String right) {
            this.right = right;
            return this;
        }

        public LineComponentBuilder leftColor(Color leftColor) {
            this.leftColor$value = leftColor;
            this.leftColor$set = true;
            return this;
        }

        public LineComponentBuilder rightColor(Color rightColor) {
            this.rightColor$value = rightColor;
            this.rightColor$set = true;
            return this;
        }

        public LineComponentBuilder preferredLocation(Point preferredLocation) {
            this.preferredLocation$value = preferredLocation;
            this.preferredLocation$set = true;
            return this;
        }

        public LineComponentBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize$value = preferredSize;
            this.preferredSize$set = true;
            return this;
        }

        public LineComponentBuilder bounds(Rectangle bounds) {
            this.bounds$value = bounds;
            this.bounds$set = true;
            return this;
        }

        public LineComponent build() {
            Color leftColor$value = this.leftColor$value;
            if (!this.leftColor$set) {
                leftColor$value = LineComponent.$default$leftColor();
            }
            Color rightColor$value = this.rightColor$value;
            if (!this.rightColor$set) {
                rightColor$value = LineComponent.$default$rightColor();
            }
            Point preferredLocation$value = this.preferredLocation$value;
            if (!this.preferredLocation$set) {
                preferredLocation$value = LineComponent.$default$preferredLocation();
            }
            Dimension preferredSize$value = this.preferredSize$value;
            if (!this.preferredSize$set) {
                preferredSize$value = LineComponent.$default$preferredSize();
            }
            Rectangle bounds$value = this.bounds$value;
            if (!this.bounds$set) {
                bounds$value = LineComponent.$default$bounds();
            }
            return new LineComponent(this.left, this.right, leftColor$value, rightColor$value, preferredLocation$value, preferredSize$value, bounds$value);
        }

        public String toString() {
            return "LineComponent.LineComponentBuilder(left=" + this.left + ", right=" + this.right + ", leftColor$value=" + this.leftColor$value + ", rightColor$value=" + this.rightColor$value + ", preferredLocation$value=" + this.preferredLocation$value + ", preferredSize$value=" + this.preferredSize$value + ", bounds$value=" + this.bounds$value + ")";
        }
    }
}

