/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import net.runelite.client.ui.overlay.RenderableEntity;
import net.runelite.client.ui.overlay.components.ComponentConstants;

public class BackgroundComponent
implements RenderableEntity {
    private static final int BORDER_OFFSET = 2;
    private static final int OUTSIDE_STROKE_RED_OFFSET = 14;
    private static final int OUTSIDE_STROKE_GREEN_OFFSET = 13;
    private static final int OUTSIDE_STROKE_BLUE_OFFSET = 15;
    private static final int OUTSIDE_STROKE_ALPHA = 255;
    private static final int INSIDE_STROKE_RED_OFFSET = 20;
    private static final int INSIDE_STROKE_GREEN_OFFSET = 21;
    private static final int INSIDE_STROKE_BLUE_OFFSET = 19;
    private static final int INSIDE_STROKE_ALPHA = 255;
    private Color backgroundColor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
    private Rectangle rectangle = new Rectangle();
    private boolean fill = true;

    @Override
    public Dimension render(Graphics2D graphics) {
        Color outsideStrokeColor = new Color(Math.max(0, this.backgroundColor.getRed() - 14), Math.max(0, this.backgroundColor.getGreen() - 13), Math.max(0, this.backgroundColor.getBlue() - 15), 255);
        Color insideStrokeColor = new Color(Math.min(255, this.backgroundColor.getRed() + 20), Math.min(255, this.backgroundColor.getGreen() + 21), Math.min(255, this.backgroundColor.getBlue() + 19), 255);
        if (this.fill) {
            graphics.setColor(this.backgroundColor);
            graphics.fill(this.rectangle);
        }
        Rectangle outsideStroke = new Rectangle();
        outsideStroke.setLocation(this.rectangle.x, this.rectangle.y);
        outsideStroke.setSize(this.rectangle.width - 1, this.rectangle.height - 1);
        graphics.setColor(outsideStrokeColor);
        graphics.draw(outsideStroke);
        Rectangle insideStroke = new Rectangle();
        insideStroke.setLocation(this.rectangle.x + 1, this.rectangle.y + 1);
        insideStroke.setSize(this.rectangle.width - 2 - 1, this.rectangle.height - 2 - 1);
        graphics.setColor(insideStrokeColor);
        graphics.draw(insideStroke);
        return new Dimension(this.rectangle.getSize());
    }

    public BackgroundComponent() {
    }

    public BackgroundComponent(Color backgroundColor, Rectangle rectangle, boolean fill) {
        this.backgroundColor = backgroundColor;
        this.rectangle = rectangle;
        this.fill = fill;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }
}

