/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay;

import com.google.common.collect.ImmutableMap;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class WidgetOverlay
extends Overlay {
    private static final Map<WidgetInfo, OverlayPosition> WIDGETS = ImmutableMap.builder().put(WidgetInfo.RESIZABLE_MINIMAP_WIDGET, OverlayPosition.CANVAS_TOP_RIGHT).put(WidgetInfo.RESIZABLE_MINIMAP_STONES_WIDGET, OverlayPosition.CANVAS_TOP_RIGHT).put(WidgetInfo.FOSSIL_ISLAND_OXYGENBAR, OverlayPosition.TOP_LEFT).put(WidgetInfo.EXPERIENCE_TRACKER_WIDGET, OverlayPosition.TOP_RIGHT).put(WidgetInfo.TOURNAMENT_INFO_WIDGET, OverlayPosition.TOP_RIGHT).put(WidgetInfo.RAIDS_POINTS_INFOBOX, OverlayPosition.TOP_RIGHT).put(WidgetInfo.TITHE_FARM, OverlayPosition.TOP_RIGHT).put(WidgetInfo.PEST_CONTROL_BOAT_INFO, OverlayPosition.TOP_LEFT).put(WidgetInfo.PEST_CONTROL_INFO, OverlayPosition.TOP_LEFT).put(WidgetInfo.ZEAH_MESS_HALL_COOKING_DISPLAY, OverlayPosition.TOP_LEFT).put(WidgetInfo.PVP_BOUNTY_HUNTER_INFO, OverlayPosition.TOP_RIGHT).put(WidgetInfo.PVP_KILLDEATH_COUNTER, OverlayPosition.TOP_LEFT).put(WidgetInfo.SKOTIZO_CONTAINER, OverlayPosition.TOP_LEFT).put(WidgetInfo.KOUREND_FAVOUR_OVERLAY, OverlayPosition.TOP_CENTER).put(WidgetInfo.PYRAMID_PLUNDER_DATA, OverlayPosition.TOP_CENTER).build();
    private final Client client;
    private final WidgetInfo widgetInfo;
    private final Rectangle parentBounds = new Rectangle();

    public static Collection<WidgetOverlay> createOverlays(Client client2) {
        return WIDGETS.entrySet().stream().map(w -> new WidgetOverlay(client2, (WidgetInfo)((Object)((Object)w.getKey())), (OverlayPosition)((Object)((Object)w.getValue())))).collect(Collectors.toList());
    }

    private WidgetOverlay(Client client2, WidgetInfo widgetInfo, OverlayPosition overlayPosition) {
        this.client = client2;
        this.widgetInfo = widgetInfo;
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPosition(overlayPosition);
    }

    @Override
    public String getName() {
        return Objects.toString((Object)this.widgetInfo);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        Rectangle parent = this.getParentBounds(this.client.getWidget(this.widgetInfo));
        if (parent.isEmpty()) {
            return bounds;
        }
        int x = bounds.x;
        int y = bounds.y;
        x = Math.max(parent.x, x);
        y = Math.max(parent.y, y);
        x = Math.min((int)parent.getMaxX() - bounds.width, x);
        y = Math.min((int)parent.getMaxY() - bounds.height, y);
        bounds.setLocation(x, y);
        return bounds;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget widget = this.client.getWidget(this.widgetInfo);
        Rectangle bounds = super.getBounds();
        Rectangle parent = this.getParentBounds(widget);
        if (parent.isEmpty()) {
            return null;
        }
        int x = bounds.x;
        int y = bounds.y;
        x = Math.max(parent.x, x);
        y = Math.max(parent.y, y);
        x = Math.min((int)parent.getMaxX() - bounds.width, x);
        y = Math.min((int)parent.getMaxY() - bounds.height, y);
        bounds.setLocation(x, y);
        widget.setOriginalX(0);
        widget.setOriginalY(0);
        widget.setRelativeX(bounds.x - parent.x);
        widget.setRelativeY(bounds.y - parent.y);
        return new Dimension(widget.getWidth(), widget.getHeight());
    }

    private Rectangle getParentBounds(Widget widget) {
        if (!this.client.isClientThread()) {
            return this.parentBounds;
        }
        if (widget == null || widget.isHidden()) {
            this.parentBounds.setBounds(new Rectangle());
            return this.parentBounds;
        }
        Widget parent = widget.getParent();
        Rectangle bounds = parent == null ? new Rectangle(this.client.getRealDimensions()) : new Rectangle(parent.getCanvasLocation().getX(), parent.getCanvasLocation().getY(), parent.getWidth(), parent.getHeight());
        this.parentBounds.setBounds(bounds);
        return bounds;
    }
}

