/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public abstract class WidgetItemOverlay
extends Overlay {
    private OverlayManager overlayManager;
    private final Set<Integer> interfaceGroups = new HashSet<Integer>();

    protected WidgetItemOverlay() {
        super.setPosition(OverlayPosition.DYNAMIC);
        super.setPriority(OverlayPriority.LOW);
        super.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public abstract void renderItemOverlay(Graphics2D var1, int var2, WidgetItem var3);

    @Override
    public Dimension render(Graphics2D graphics) {
        List<WidgetItem> itemWidgets = this.overlayManager.getItemWidgets();
        for (WidgetItem widgetItem : itemWidgets) {
            Widget widget = widgetItem.getWidget();
            int interfaceGroup = WidgetInfo.TO_GROUP(widget.getId());
            if (!this.interfaceGroups.contains(interfaceGroup)) continue;
            this.renderItemOverlay(graphics, widgetItem.getId(), widgetItem);
        }
        return null;
    }

    protected void showOnInventory() {
        this.showOnInterfaces(192, 15, 301, 467, 238, 85, 149);
    }

    protected void showOnBank() {
        this.showOnInterfaces(12);
    }

    protected void showOnEquipment() {
        this.showOnInterfaces(387);
    }

    protected void showOnInterfaces(int ... ids) {
        Arrays.stream(ids).forEach(this.interfaceGroups::add);
    }

    @Override
    public void setPosition(OverlayPosition position) {
        throw new IllegalStateException();
    }

    @Override
    public void setPriority(OverlayPriority priority) {
        throw new IllegalStateException();
    }

    @Override
    public void setLayer(OverlayLayer layer) {
        throw new IllegalStateException();
    }

    void setOverlayManager(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
    }
}

