/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Point;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.input.MouseManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayBounds;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

@Singleton
public class OverlayRenderer
extends MouseAdapter
implements KeyListener {
    private static final int BORDER = 5;
    private static final int BORDER_TOP = 20;
    private static final int PADDING = 2;
    private static final Dimension SNAP_CORNER_SIZE = new Dimension(80, 80);
    private static final Color SNAP_CORNER_COLOR = new Color(0, 255, 255, 50);
    private static final Color SNAP_CORNER_ACTIVE_COLOR = new Color(0, 255, 0, 100);
    private static final Color MOVING_OVERLAY_COLOR = new Color(255, 255, 0, 100);
    private static final Color MOVING_OVERLAY_ACTIVE_COLOR = new Color(255, 255, 0, 200);
    private final Client client;
    private final OverlayManager overlayManager;
    private final RuneLiteConfig runeLiteConfig;
    private final java.awt.Point overlayOffset = new java.awt.Point();
    private final java.awt.Point mousePosition = new java.awt.Point();
    private Overlay movedOverlay;
    private boolean inOverlayDraggingMode;
    private boolean inMenuEntryMode;
    private MenuEntry[] menuEntries;
    private Rectangle viewportBounds;
    private Rectangle chatboxBounds;
    private int viewportOffset;
    private boolean chatboxHidden;
    private boolean isResizeable;
    private OverlayBounds snapCorners;

    @Inject
    private OverlayRenderer(Client client2, OverlayManager overlayManager, RuneLiteConfig runeLiteConfig, MouseManager mouseManager, KeyManager keyManager) {
        this.client = client2;
        this.overlayManager = overlayManager;
        this.runeLiteConfig = runeLiteConfig;
        keyManager.registerKeyListener(this);
        mouseManager.registerMouseListener(this);
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (!event.isFocused()) {
            this.inOverlayDraggingMode = false;
            this.inMenuEntryMode = false;
            this.menuEntries = null;
        }
    }

    @Subscribe
    protected void onClientTick(ClientTick t) {
        if (this.menuEntries == null) {
            return;
        }
        if (!this.inMenuEntryMode && this.runeLiteConfig.menuEntryShift()) {
            return;
        }
        if (this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] clientMenuEntries = this.client.getMenuEntries();
        MenuEntry[] newEntries = new MenuEntry[clientMenuEntries.length + this.menuEntries.length];
        newEntries[0] = clientMenuEntries[0];
        System.arraycopy(this.menuEntries, 0, newEntries, 1, this.menuEntries.length);
        System.arraycopy(clientMenuEntries, 1, newEntries, this.menuEntries.length + 1, clientMenuEntries.length - 1);
        this.client.setMenuEntries(newEntries);
    }

    @Subscribe
    public void onBeforeRender(BeforeRender event) {
        this.menuEntries = null;
    }

    public void render(Graphics2D graphics, OverlayLayer layer) {
        if (layer != OverlayLayer.ABOVE_MAP && this.client.getWidget(WidgetInfo.FULLSCREEN_MAP_ROOT) != null && !this.client.getWidget(WidgetInfo.FULLSCREEN_MAP_ROOT).isHidden()) {
            return;
        }
        List<Overlay> overlays = this.overlayManager.getLayer(layer);
        if (overlays == null || overlays.isEmpty() || this.client.getGameState() != GameState.LOGGED_IN || this.client.getWidget(WidgetInfo.LOGIN_CLICK_TO_PLAY_SCREEN) != null || this.client.getViewportWidget() == null) {
            return;
        }
        if (this.shouldInvalidateBounds()) {
            this.snapCorners = this.buildSnapCorners();
        }
        OverlayBounds snapCorners = new OverlayBounds(this.snapCorners);
        OverlayUtil.setGraphicProperties(graphics);
        if (layer == OverlayLayer.UNDER_WIDGETS && this.movedOverlay != null && this.movedOverlay.getPosition() != OverlayPosition.DETACHED) {
            OverlayBounds translatedSnapCorners = snapCorners.translated(-OverlayRenderer.SNAP_CORNER_SIZE.width, -OverlayRenderer.SNAP_CORNER_SIZE.height);
            Color previous = graphics.getColor();
            for (Rectangle corner : translatedSnapCorners.getBounds()) {
                graphics.setColor(corner.contains(this.mousePosition) ? SNAP_CORNER_ACTIVE_COLOR : SNAP_CORNER_COLOR);
                graphics.fill(corner);
            }
            graphics.setColor(previous);
        }
        Point mouseCanvasPosition = this.client.getMouseCanvasPosition();
        java.awt.Point mouse = new java.awt.Point(mouseCanvasPosition.getX(), mouseCanvasPosition.getY());
        for (Overlay overlay : overlays) {
            OverlayPosition overlayPosition = overlay.getPosition();
            if (overlay.getPreferredPosition() != null) {
                overlayPosition = overlay.getPreferredPosition();
            }
            if (!this.isResizeable) {
                switch (overlayPosition) {
                    case CANVAS_TOP_RIGHT: {
                        overlayPosition = OverlayPosition.TOP_RIGHT;
                        break;
                    }
                    case ABOVE_CHATBOX_RIGHT: {
                        overlayPosition = OverlayPosition.BOTTOM_RIGHT;
                    }
                }
            }
            if (overlayPosition == OverlayPosition.DYNAMIC || overlayPosition == OverlayPosition.TOOLTIP) {
                this.safeRender(this.client, overlay, layer, graphics, new java.awt.Point());
                continue;
            }
            java.awt.Point location = overlay.getBounds().getLocation();
            Dimension dimension = overlay.getBounds().getSize();
            if (overlayPosition != OverlayPosition.DETACHED && (overlay.getPreferredLocation() == null || overlay.getPreferredPosition() != null)) {
                Rectangle snapCorner = snapCorners.forPosition(overlayPosition);
                java.awt.Point translation = OverlayUtil.transformPosition(overlayPosition, dimension);
                location.setLocation(snapCorner.getX() + (double)translation.x, snapCorner.getY() + (double)translation.y);
                java.awt.Point padding = OverlayUtil.padPosition(overlayPosition, dimension, 2);
                snapCorner.translate(padding.x, padding.y);
            } else {
                java.awt.Point preferredLocation = overlay.getPreferredLocation();
                if (preferredLocation != null) {
                    location.setLocation(preferredLocation);
                }
                Dimension realDimensions = this.client.getRealDimensions();
                location.x = Ints.constrainToRange(location.x, 0, Math.max(0, realDimensions.width - dimension.width));
                location.y = Ints.constrainToRange(location.y, 0, Math.max(0, realDimensions.height - dimension.height));
            }
            if (overlay.getPreferredSize() != null) {
                overlay.getBounds().setSize(overlay.getPreferredSize());
            }
            this.safeRender(this.client, overlay, layer, graphics, location);
            Rectangle bounds = overlay.getBounds();
            if (bounds.isEmpty()) continue;
            if (this.inOverlayDraggingMode) {
                Color previous = graphics.getColor();
                graphics.setColor(this.movedOverlay == overlay ? MOVING_OVERLAY_ACTIVE_COLOR : MOVING_OVERLAY_COLOR);
                graphics.draw(bounds);
                graphics.setColor(previous);
            }
            if (this.menuEntries != null || this.client.isMenuOpen() || !bounds.contains(mouse)) continue;
            this.menuEntries = this.createRightClickMenuEntries(overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        if (!this.inOverlayDraggingMode) {
            return mouseEvent;
        }
        java.awt.Point mousePoint = mouseEvent.getPoint();
        this.mousePosition.setLocation(mousePoint);
        OverlayManager overlayManager = this.overlayManager;
        synchronized (overlayManager) {
            for (Overlay overlay : this.overlayManager.getOverlays()) {
                if (!overlay.getBounds().contains(mousePoint)) continue;
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.overlayManager.resetOverlay(overlay);
                } else {
                    java.awt.Point offset = new java.awt.Point(mousePoint.x, mousePoint.y);
                    offset.translate(-overlay.getBounds().x, -overlay.getBounds().y);
                    this.overlayOffset.setLocation(offset);
                    mousePoint.translate(-offset.x, -offset.y);
                    this.movedOverlay = overlay;
                    this.movedOverlay.setPreferredPosition(null);
                    this.movedOverlay.setPreferredLocation(mousePoint);
                    this.overlayManager.saveOverlay(this.movedOverlay);
                }
                mouseEvent.consume();
                break;
            }
        }
        return mouseEvent;
    }

    @Override
    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        if (!this.inOverlayDraggingMode) {
            return mouseEvent;
        }
        java.awt.Point mousePoint = mouseEvent.getPoint();
        this.mousePosition.setLocation(mousePoint);
        Rectangle canvasRect = new Rectangle(this.client.getRealDimensions());
        if (!canvasRect.contains(mousePoint)) {
            return mouseEvent;
        }
        if (this.movedOverlay != null) {
            Dimension realDimension = this.client.getRealDimensions();
            mousePoint.translate(-this.overlayOffset.x, -this.overlayOffset.y);
            mousePoint.x = Ints.constrainToRange(mousePoint.x, 0, Math.max(0, realDimension.width - this.movedOverlay.getBounds().width));
            mousePoint.y = Ints.constrainToRange(mousePoint.y, 0, Math.max(0, realDimension.height - this.movedOverlay.getBounds().height));
            this.movedOverlay.setPreferredPosition(null);
            this.movedOverlay.setPreferredLocation(mousePoint);
            mouseEvent.consume();
        }
        return mouseEvent;
    }

    @Override
    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        if (this.movedOverlay != null) {
            this.mousePosition.setLocation(-1, -1);
            if (this.movedOverlay.getPosition() != OverlayPosition.DETACHED) {
                OverlayBounds snapCorners = this.snapCorners.translated(-OverlayRenderer.SNAP_CORNER_SIZE.width, -OverlayRenderer.SNAP_CORNER_SIZE.height);
                for (Rectangle snapCorner : snapCorners.getBounds()) {
                    if (!snapCorner.contains(mouseEvent.getPoint())) continue;
                    OverlayPosition position = snapCorners.fromBounds(snapCorner);
                    if (position == this.movedOverlay.getPosition()) {
                        position = null;
                    }
                    this.movedOverlay.setPreferredPosition(position);
                    this.movedOverlay.setPreferredLocation(null);
                    break;
                }
            }
            this.overlayManager.saveOverlay(this.movedOverlay);
            this.movedOverlay = null;
            mouseEvent.consume();
        }
        return mouseEvent;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isAltDown()) {
            this.inOverlayDraggingMode = true;
        }
        if (e.isShiftDown() && this.runeLiteConfig.menuEntryShift()) {
            this.inMenuEntryMode = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!e.isAltDown()) {
            this.inOverlayDraggingMode = false;
        }
        if (!e.isShiftDown()) {
            this.inMenuEntryMode = false;
        }
    }

    private void safeRender(Client client2, Overlay overlay, OverlayLayer layer, Graphics2D graphics, java.awt.Point point) {
        OverlayPosition position;
        Graphics2D subGraphics = (Graphics2D)graphics.create();
        if (!(this.isResizeable || layer != OverlayLayer.ABOVE_SCENE && layer != OverlayLayer.UNDER_WIDGETS)) {
            subGraphics.setClip(client2.getViewportXOffset(), client2.getViewportYOffset(), client2.getViewportWidth(), client2.getViewportHeight());
        }
        if ((position = overlay.getPosition()) == OverlayPosition.DYNAMIC || position == OverlayPosition.DETACHED) {
            subGraphics.setFont(this.runeLiteConfig.fontType().getFont());
        } else if (position == OverlayPosition.TOOLTIP) {
            subGraphics.setFont(this.runeLiteConfig.tooltipFontType().getFont());
        } else {
            subGraphics.setFont(this.runeLiteConfig.interfaceFontType().getFont());
        }
        subGraphics.translate(point.x, point.y);
        Dimension dimension = MoreObjects.firstNonNull(overlay.render(subGraphics), new Dimension());
        subGraphics.dispose();
        overlay.setBounds(new Rectangle(point, dimension));
    }

    private boolean shouldInvalidateBounds() {
        boolean viewportOffsetChanged;
        boolean viewportChanged;
        boolean chatboxHiddenChanged;
        boolean chatboxBoundsChanged;
        Widget chatbox = this.client.getWidget(WidgetInfo.CHATBOX);
        boolean resizeableChanged = this.isResizeable != this.client.isResized();
        boolean changed = false;
        if (resizeableChanged) {
            this.isResizeable = this.client.isResized();
            changed = true;
        }
        boolean bl = chatboxBoundsChanged = chatbox == null || !chatbox.getBounds().equals(this.chatboxBounds);
        if (chatboxBoundsChanged) {
            this.chatboxBounds = chatbox != null ? chatbox.getBounds() : new Rectangle();
            changed = true;
        }
        boolean bl2 = chatboxHiddenChanged = this.chatboxHidden != (chatbox == null || chatbox.isHidden());
        if (chatboxHiddenChanged) {
            this.chatboxHidden = chatbox == null || chatbox.isHidden();
            changed = true;
        }
        boolean bl3 = viewportChanged = !this.client.getViewportWidget().getBounds().equals(this.viewportBounds);
        if (viewportChanged) {
            this.viewportBounds = this.client.getViewportWidget().getBounds();
            changed = true;
        }
        boolean bl4 = viewportOffsetChanged = this.client.getViewportXOffset() != this.viewportOffset;
        if (viewportOffsetChanged) {
            this.viewportOffset = this.client.getViewportXOffset();
            changed = true;
        }
        return changed;
    }

    private OverlayBounds buildSnapCorners() {
        java.awt.Point topLeftPoint = new java.awt.Point(this.viewportOffset + 5, this.viewportOffset + 20);
        java.awt.Point topCenterPoint = new java.awt.Point(this.viewportOffset + this.viewportBounds.width / 2, this.viewportOffset + 5);
        java.awt.Point topRightPoint = new java.awt.Point(this.viewportOffset + this.viewportBounds.width - 5, topCenterPoint.y);
        java.awt.Point bottomLeftPoint = new java.awt.Point(topLeftPoint.x, this.viewportOffset + this.viewportBounds.height - 5);
        java.awt.Point bottomRightPoint = new java.awt.Point(topRightPoint.x, bottomLeftPoint.y);
        if (this.isResizeable && this.chatboxHidden) {
            bottomLeftPoint.y += this.chatboxBounds.height;
        }
        java.awt.Point rightChatboxPoint = this.isResizeable ? new java.awt.Point(this.viewportOffset + this.chatboxBounds.width - 5, bottomLeftPoint.y) : bottomRightPoint;
        java.awt.Point canvasTopRightPoint = this.isResizeable ? new java.awt.Point((int)this.client.getRealDimensions().getWidth(), 0) : topRightPoint;
        return new OverlayBounds(new Rectangle(topLeftPoint, SNAP_CORNER_SIZE), new Rectangle(topCenterPoint, SNAP_CORNER_SIZE), new Rectangle(topRightPoint, SNAP_CORNER_SIZE), new Rectangle(bottomLeftPoint, SNAP_CORNER_SIZE), new Rectangle(bottomRightPoint, SNAP_CORNER_SIZE), new Rectangle(rightChatboxPoint, SNAP_CORNER_SIZE), new Rectangle(canvasTopRightPoint, SNAP_CORNER_SIZE));
    }

    private MenuEntry[] createRightClickMenuEntries(Overlay overlay) {
        List<OverlayMenuEntry> menuEntries = overlay.getMenuEntries();
        MenuEntry[] entries = new MenuEntry[menuEntries.size()];
        for (int i = menuEntries.size() - 1; i >= 0; --i) {
            OverlayMenuEntry overlayMenuEntry = menuEntries.get(i);
            MenuEntry entry = new MenuEntry();
            entry.setOption(overlayMenuEntry.getOption());
            entry.setTarget(ColorUtil.wrapWithColorTag(overlayMenuEntry.getTarget(), JagexColors.MENU_TARGET));
            entry.setType(MenuAction.RUNELITE_OVERLAY.getId());
            entry.setIdentifier(this.overlayManager.getOverlays().indexOf(overlay));
            entries[i] = entry;
        }
        return entries;
    }
}

