/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.MenuAction;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.WidgetOverlay;

@Singleton
public class OverlayManager {
    public static final String OPTION_CONFIGURE = "Configure";
    private static final String OVERLAY_CONFIG_PREFERRED_LOCATION = "_preferredLocation";
    private static final String OVERLAY_CONFIG_PREFERRED_POSITION = "_preferredPosition";
    private static final String OVERLAY_CONFIG_PREFERRED_SIZE = "_preferredSize";
    private static final String RUNELITE_CONFIG_GROUP_NAME = RuneLiteConfig.class.getAnnotation(ConfigGroup.class).value();
    @VisibleForTesting
    static final Comparator<Overlay> OVERLAY_COMPARATOR = (a, b) -> {
        OverlayPosition bPos;
        OverlayPosition aPos = a.getPreferredPosition() != null ? a.getPreferredPosition() : a.getPosition();
        OverlayPosition overlayPosition = bPos = b.getPreferredPosition() != null ? b.getPreferredPosition() : b.getPosition();
        if (aPos != bPos) {
            return aPos.compareTo(bPos);
        }
        return aPos == OverlayPosition.DYNAMIC ? a.getPriority().compareTo(b.getPriority()) : b.getPriority().compareTo(a.getPriority());
    };
    private final List<Overlay> overlays = new ArrayList<Overlay>();
    private final List<WidgetItem> itemWidgets = new ArrayList<WidgetItem>();
    private final Map<OverlayLayer, List<Overlay>> overlayLayers = new EnumMap<OverlayLayer, List<Overlay>>(OverlayLayer.class);
    private final ConfigManager configManager;
    private final EventBus eventBus;

    @Inject
    private OverlayManager(ConfigManager configManager, EventBus eventBus) {
        this.configManager = configManager;
        this.eventBus = eventBus;
    }

    @Subscribe
    public void onPluginChanged(PluginChanged event) {
        this.overlays.forEach(this::loadOverlay);
        this.rebuildOverlayLayers();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Overlay overlay;
        List<OverlayMenuEntry> menuEntries;
        Optional<OverlayMenuEntry> optionalOverlayMenuEntry;
        if (event.getMenuAction() != MenuAction.RUNELITE_OVERLAY) {
            return;
        }
        event.consume();
        Optional<Overlay> optionalOverlay = this.overlays.stream().filter(o -> this.overlays.indexOf(o) == event.getId()).findAny();
        if (optionalOverlay.isPresent() && (optionalOverlayMenuEntry = (menuEntries = (overlay = optionalOverlay.get()).getMenuEntries()).stream().filter(me -> me.getOption().equals(event.getMenuOption())).findAny()).isPresent()) {
            this.eventBus.post(new OverlayMenuClicked(optionalOverlayMenuEntry.get(), overlay));
        }
    }

    synchronized List<Overlay> getLayer(OverlayLayer layer) {
        return this.overlayLayers.get((Object)layer);
    }

    public synchronized boolean add(Overlay overlay) {
        if (this.overlays.contains(overlay)) {
            return false;
        }
        this.overlays.add(overlay);
        this.loadOverlay(overlay);
        if (overlay instanceof WidgetItemOverlay) {
            ((WidgetItemOverlay)overlay).setOverlayManager(this);
        }
        this.rebuildOverlayLayers();
        return true;
    }

    public synchronized boolean remove(Overlay overlay) {
        boolean remove = this.overlays.remove(overlay);
        if (remove) {
            this.rebuildOverlayLayers();
        }
        return remove;
    }

    public synchronized boolean removeIf(Predicate<Overlay> filter) {
        boolean removeIf = this.overlays.removeIf(filter);
        if (removeIf) {
            this.rebuildOverlayLayers();
        }
        return removeIf;
    }

    public synchronized void clear() {
        this.overlays.clear();
        this.rebuildOverlayLayers();
    }

    public synchronized void saveOverlay(Overlay overlay) {
        this.saveOverlayPosition(overlay);
        this.saveOverlaySize(overlay);
        this.saveOverlayLocation(overlay);
        this.rebuildOverlayLayers();
    }

    public synchronized void resetOverlay(Overlay overlay) {
        overlay.setPreferredPosition(null);
        overlay.setPreferredSize(null);
        overlay.setPreferredLocation(null);
        this.saveOverlay(overlay);
    }

    private synchronized void rebuildOverlayLayers() {
        for (OverlayLayer l : OverlayLayer.values()) {
            this.overlayLayers.put(l, new ArrayList());
        }
        for (Overlay overlay : this.overlays) {
            OverlayLayer layer2 = overlay.getLayer();
            if (overlay.getPreferredLocation() != null && overlay.getPreferredPosition() == null && layer2 == OverlayLayer.UNDER_WIDGETS && !(overlay instanceof WidgetOverlay)) {
                layer2 = OverlayLayer.ABOVE_WIDGETS;
            }
            this.overlayLayers.get((Object)layer2).add(overlay);
        }
        this.overlayLayers.forEach((layer, value) -> {
            value.sort(OVERLAY_COMPARATOR);
            this.overlayLayers.put((OverlayLayer)((Object)layer), Collections.unmodifiableList(value));
        });
    }

    private void loadOverlay(Overlay overlay) {
        Point location = this.loadOverlayLocation(overlay);
        overlay.setPreferredLocation(location);
        Dimension size = this.loadOverlaySize(overlay);
        overlay.setPreferredSize(size);
        OverlayPosition position = this.loadOverlayPosition(overlay);
        overlay.setPreferredPosition(position);
    }

    private void saveOverlayLocation(Overlay overlay) {
        String key = overlay.getName() + OVERLAY_CONFIG_PREFERRED_LOCATION;
        if (overlay.getPreferredLocation() != null) {
            this.configManager.setConfiguration(RUNELITE_CONFIG_GROUP_NAME, key, overlay.getPreferredLocation());
        } else {
            this.configManager.unsetConfiguration(RUNELITE_CONFIG_GROUP_NAME, key);
        }
    }

    private void saveOverlaySize(Overlay overlay) {
        String key = overlay.getName() + OVERLAY_CONFIG_PREFERRED_SIZE;
        if (overlay.getPreferredSize() != null) {
            this.configManager.setConfiguration(RUNELITE_CONFIG_GROUP_NAME, key, overlay.getPreferredSize());
        } else {
            this.configManager.unsetConfiguration(RUNELITE_CONFIG_GROUP_NAME, key);
        }
    }

    private void saveOverlayPosition(Overlay overlay) {
        String key = overlay.getName() + OVERLAY_CONFIG_PREFERRED_POSITION;
        if (overlay.getPreferredPosition() != null) {
            this.configManager.setConfiguration(RUNELITE_CONFIG_GROUP_NAME, key, (Object)overlay.getPreferredPosition());
        } else {
            this.configManager.unsetConfiguration(RUNELITE_CONFIG_GROUP_NAME, key);
        }
    }

    private Point loadOverlayLocation(Overlay overlay) {
        String key = overlay.getName() + OVERLAY_CONFIG_PREFERRED_LOCATION;
        return this.configManager.getConfiguration(RUNELITE_CONFIG_GROUP_NAME, key, Point.class);
    }

    private Dimension loadOverlaySize(Overlay overlay) {
        String key = overlay.getName() + OVERLAY_CONFIG_PREFERRED_SIZE;
        return this.configManager.getConfiguration(RUNELITE_CONFIG_GROUP_NAME, key, Dimension.class);
    }

    private OverlayPosition loadOverlayPosition(Overlay overlay) {
        String locationKey = overlay.getName() + OVERLAY_CONFIG_PREFERRED_POSITION;
        return this.configManager.getConfiguration(RUNELITE_CONFIG_GROUP_NAME, locationKey, OverlayPosition.class);
    }

    List<Overlay> getOverlays() {
        return this.overlays;
    }

    public List<WidgetItem> getItemWidgets() {
        return this.itemWidgets;
    }
}

