/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.rs;

import java.applet.Applet;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.client.rs.ClientConfigLoader;
import net.runelite.client.rs.ClientUpdateCheckMode;
import net.runelite.client.rs.RSAppletStub;
import net.runelite.client.rs.RSConfig;
import net.runelite.standalone.client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClientLoader {
    private static final Logger log = LoggerFactory.getLogger(ClientLoader.class);
    private final ClientConfigLoader clientConfigLoader;
    private final ClientUpdateCheckMode updateCheckMode;

    @Inject
    private ClientLoader(@Named(value="updateCheckMode") ClientUpdateCheckMode updateCheckMode, ClientConfigLoader clientConfigLoader) {
        this.updateCheckMode = updateCheckMode;
        this.clientConfigLoader = clientConfigLoader;
    }

    private static Applet loadRuneLite(RSConfig config) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClientLoader.loadFromClass(config, client.class);
    }

    private static Applet loadVanilla(RSConfig config) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String codebase = config.getCodeBase();
        String initialJar = config.getInitialJar();
        String initialClass = config.getInitialClass();
        URL url = new URL(codebase + initialJar);
        URLClassLoader classloader = new URLClassLoader(new URL[]{url}, null);
        Class<?> clientClass = classloader.loadClass(initialClass);
        return ClientLoader.loadFromClass(config, clientClass);
    }

    private static Applet loadFromClass(RSConfig config, Class<?> clientClass) throws IllegalAccessException, InstantiationException {
        Applet rs = (Applet)clientClass.newInstance();
        rs.setStub(new RSAppletStub(config));
        return rs;
    }

    public Applet load() {
        try {
            RSConfig config = this.clientConfigLoader.fetch();
            return ClientLoader.loadRuneLite(config);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            if (e instanceof ClassNotFoundException) {
                log.error("Unable to load client - class not found. This means you are not running RuneLite with Maven as the injected client is not in your classpath.");
            }
            log.error("Error loading RS!", e);
            System.exit(-1);
            return null;
        }
    }
}

