/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.rs;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.rs.RSConfig;
import okhttp3.OkHttpClient;

@Singleton
class ClientConfigLoader {
    private static final String CONFIG_URL = "http://oldschool.runescape.com/jav_config.ws";
    private final OkHttpClient httpClient;

    @Inject
    @VisibleForTesting
    ClientConfigLoader(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RSConfig fetch() throws IOException {
        RSConfig config = new RSConfig();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("jav_config.ws")));){
            String str;
            block13: while ((str = in.readLine()) != null) {
                String s;
                int idx = str.indexOf(61);
                if (idx == -1) continue;
                switch (s = str.substring(0, idx)) {
                    case "param": {
                        str = str.substring(idx + 1);
                        idx = str.indexOf(61);
                        s = str.substring(0, idx);
                        config.getAppletProperties().put(s, str.substring(idx + 1));
                        continue block13;
                    }
                    case "msg": {
                        continue block13;
                    }
                }
                config.getClassLoaderProperties().put(s, str.substring(idx + 1));
            }
            return config;
        }
    }
}

