/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.zoom;

import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import net.runelite.api.Client;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.zoom.ZoomConfig;

@PluginDescriptor(name="Camera Zoom", description="Expand zoom limit and/or enable vertical camera", tags={"limit", "vertical"}, enabledByDefault=false)
public class ZoomPlugin
extends Plugin
implements KeyListener {
    private static final int INNER_ZOOM_LIMIT = 1004;
    private boolean controlDown;
    @Inject
    private Client client;
    @Inject
    private ZoomConfig zoomConfig;
    @Inject
    private KeyManager keyManager;

    @Provides
    ZoomConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ZoomConfig.class);
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (this.client.getIndexScripts().isOverlayOutdated()) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        if ("scrollWheelZoom".equals(event.getEventName()) && this.zoomConfig.requireControlDown() && !this.controlDown) {
            intStack[intStackSize - 1] = 1;
        }
        if ("innerZoomLimit".equals(event.getEventName()) && this.zoomConfig.innerLimit()) {
            intStack[intStackSize - 1] = 1004;
            return;
        }
        if ("outerZoomLimit".equals(event.getEventName())) {
            int outerZoomLimit;
            int outerLimit = Ints.constrainToRange(this.zoomConfig.outerLimit(), -400, 400);
            intStack[intStackSize - 1] = outerZoomLimit = 128 - outerLimit;
            return;
        }
        if (this.zoomConfig.innerLimit()) {
            double exponent = 2.0;
            switch (event.getEventName()) {
                case "zoomLinToExp": {
                    double range = intStack[intStackSize - 1];
                    double value = intStack[intStackSize - 2];
                    value = Math.pow(value / range, 2.0) * range;
                    intStack[intStackSize - 2] = (int)value;
                    break;
                }
                case "zoomExpToLin": {
                    double range = intStack[intStackSize - 1];
                    double value = intStack[intStackSize - 2];
                    value = Math.pow(value / range, 0.5) * range;
                    intStack[intStackSize - 2] = (int)value;
                    break;
                }
            }
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (!event.isFocused()) {
            this.controlDown = false;
        }
    }

    @Override
    protected void startUp() {
        this.client.setCameraPitchRelaxerEnabled(this.zoomConfig.relaxCameraPitch());
        this.keyManager.registerKeyListener(this);
    }

    @Override
    protected void shutDown() {
        this.client.setCameraPitchRelaxerEnabled(false);
        this.keyManager.unregisterKeyListener(this);
        this.controlDown = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged ev) {
        this.client.setCameraPitchRelaxerEnabled(this.zoomConfig.relaxCameraPitch());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.controlDown = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.controlDown = false;
        }
    }
}

