/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.xptracker;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.VarPlayer;
import net.runelite.api.WorldType;
import net.runelite.api.events.ExperienceChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.NPCManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpActionType;
import net.runelite.client.plugins.xptracker.XpInfoBoxOverlay;
import net.runelite.client.plugins.xptracker.XpPanel;
import net.runelite.client.plugins.xptracker.XpPauseState;
import net.runelite.client.plugins.xptracker.XpSnapshotSingle;
import net.runelite.client.plugins.xptracker.XpState;
import net.runelite.client.plugins.xptracker.XpStateSingle;
import net.runelite.client.plugins.xptracker.XpTrackerConfig;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.plugins.xptracker.XpTrackerServiceImpl;
import net.runelite.client.plugins.xptracker.XpUpdateResult;
import net.runelite.client.plugins.xptracker.XpWorldType;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.xp.XpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="XP Tracker", description="Enable the XP Tracker panel", tags={"experience", "levels", "panel"})
public class XpTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(XpTrackerPlugin.class);
    private static final int XP_THRESHOLD = 10000;
    static final List<Skill> COMBAT = ImmutableList.of(Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.RANGED, Skill.HITPOINTS, Skill.MAGIC);
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private XpTrackerConfig xpTrackerConfig;
    @Inject
    private NPCManager npcManager;
    @Inject
    private OverlayManager overlayManager;
    private NavigationButton navButton;
    private XpPanel xpPanel;
    private XpWorldType lastWorldType;
    private String lastUsername;
    private long lastTickMillis = 0L;
    private boolean fetchXp;
    private long lastXp = 0L;
    private final XpClient xpClient = new XpClient();
    private final XpState xpState = new XpState();
    private final XpPauseState xpPauseState = new XpPauseState();

    @Provides
    XpTrackerConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(XpTrackerConfig.class);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(XpTrackerService.class).to(XpTrackerServiceImpl.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.xpPanel = new XpPanel(this, this.xpTrackerConfig, this.client, this.skillIconManager);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "/skill_icons/overall.png");
        this.navButton = NavigationButton.builder().tooltip("XP Tracker").icon(icon).priority(2).panel(this.xpPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.removeIf(e -> e instanceof XpInfoBoxOverlay);
        this.xpState.reset();
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        if (state == GameState.LOGGED_IN) {
            XpWorldType type = this.worldSetToType(this.client.getWorldType());
            if (!Objects.equals(this.client.getUsername(), this.lastUsername) || this.lastWorldType != type) {
                log.debug("World change: {} -> {}, {} -> {}", this.lastUsername, this.client.getUsername(), MoreObjects.firstNonNull(this.lastWorldType, "<unknown>"), MoreObjects.firstNonNull(type, "<unknown>"));
                this.lastUsername = this.client.getUsername();
                this.fetchXp = true;
                this.lastWorldType = type;
                this.resetState();
            }
        } else if (state == GameState.LOGIN_SCREEN) {
            Player local = this.client.getLocalPlayer();
            if (local == null) {
                return;
            }
            String username = local.getName();
            if (username == null) {
                return;
            }
            long totalXp = this.client.getOverallExperience();
            if (Math.abs(totalXp - this.lastXp) > 10000L) {
                this.xpClient.update(username);
            }
        }
    }

    private XpWorldType worldSetToType(EnumSet<WorldType> types) {
        XpWorldType xpType = XpWorldType.NORMAL;
        for (WorldType type : types) {
            XpWorldType t = XpWorldType.of(type);
            if (t == XpWorldType.NORMAL) continue;
            xpType = t;
        }
        return xpType;
    }

    void addOverlay(Skill skill) {
        this.removeOverlay(skill);
        this.overlayManager.add(new XpInfoBoxOverlay(this, this.xpTrackerConfig, skill, this.skillIconManager.getSkillImage(skill)));
    }

    void removeOverlay(Skill skill) {
        this.overlayManager.removeIf(e -> e instanceof XpInfoBoxOverlay && ((XpInfoBoxOverlay)e).getSkill() == skill);
    }

    void resetAndInitState() {
        this.resetState();
        for (Skill skill : Skill.values()) {
            long currentXp = skill == Skill.OVERALL ? this.client.getOverallExperience() : (long)this.client.getSkillExperience(skill);
            this.xpState.initializeSkill(skill, currentXp);
            this.removeOverlay(skill);
        }
    }

    private void resetState() {
        this.xpState.reset();
        this.xpPanel.resetAllInfoBoxes();
        this.xpPanel.updateTotal(new XpSnapshotSingle.XpSnapshotSingleBuilder().build());
        this.overlayManager.removeIf(e -> e instanceof XpInfoBoxOverlay);
    }

    void resetSkillState(Skill skill) {
        int currentXp = this.client.getSkillExperience(skill);
        this.xpState.resetSkill(skill, currentXp);
        this.xpPanel.resetSkill(skill);
        this.removeOverlay(skill);
    }

    void resetOtherSkillState(Skill skill) {
        for (Skill s : Skill.values()) {
            if (skill == s || s == Skill.OVERALL) continue;
            this.resetSkillState(s);
        }
    }

    @Subscribe
    public void onExperienceChanged(ExperienceChanged event) {
        XpUpdateResult updateResult;
        int endGoalXp;
        Skill skill = event.getSkill();
        int currentXp = this.client.getSkillExperience(skill);
        int currentLevel = Experience.getLevelForXp(currentXp);
        VarPlayer startGoal = XpTrackerPlugin.startGoalVarpForSkill(skill);
        VarPlayer endGoal = XpTrackerPlugin.endGoalVarpForSkill(skill);
        int startGoalXp = startGoal != null ? this.client.getVar(startGoal) : -1;
        int n = endGoalXp = endGoal != null ? this.client.getVar(endGoal) : -1;
        if (this.xpTrackerConfig.hideMaxed() && currentLevel >= 99) {
            return;
        }
        XpStateSingle state = this.xpState.getSkill(skill);
        state.setActionType(XpActionType.EXPERIENCE);
        Actor interacting = this.client.getLocalPlayer().getInteracting();
        if (interacting instanceof NPC && COMBAT.contains((Object)skill)) {
            NPC npc = (NPC)interacting;
            this.xpState.updateNpcExperience(skill, npc, this.npcManager.getHealth(npc.getName(), npc.getCombatLevel()));
        }
        this.xpPanel.updateSkillExperience((updateResult = this.xpState.updateSkill(skill, currentXp, startGoalXp, endGoalXp)) == XpUpdateResult.UPDATED, this.xpPauseState.isPaused(skill), skill, this.xpState.getSkillSnapshot(skill));
        if (skill == Skill.CONSTRUCTION && updateResult == XpUpdateResult.INITIALIZED) {
            long overallXp = this.client.getOverallExperience();
            log.debug("Initializing XP tracker with {} overall exp", (Object)overallXp);
            this.xpState.initializeSkill(Skill.OVERALL, overallXp);
        } else if (this.xpState.isInitialized(Skill.OVERALL)) {
            this.xpState.updateSkill(Skill.OVERALL, this.client.getOverallExperience(), -1, -1);
            this.xpPanel.updateTotal(this.xpState.getTotalSnapshot());
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        NPC npc = event.getNpc();
        if (!npc.isDead()) {
            return;
        }
        for (Skill skill : COMBAT) {
            XpUpdateResult updateResult = this.xpState.updateNpcKills(skill, npc, this.npcManager.getHealth(npc.getName(), npc.getCombatLevel()));
            boolean updated = XpUpdateResult.UPDATED.equals((Object)updateResult);
            this.xpPanel.updateSkillExperience(updated, this.xpPauseState.isPaused(skill), skill, this.xpState.getSkillSnapshot(skill));
        }
        this.xpPanel.updateTotal(this.xpState.getTotalSnapshot());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.rebuildSkills();
        if (this.fetchXp) {
            this.lastXp = this.client.getOverallExperience();
            this.fetchXp = false;
        }
    }

    XpSnapshotSingle getSkillSnapshot(Skill skill) {
        return this.xpState.getSkillSnapshot(skill);
    }

    private static VarPlayer startGoalVarpForSkill(Skill skill) {
        switch (skill) {
            case ATTACK: {
                return VarPlayer.ATTACK_GOAL_START;
            }
            case MINING: {
                return VarPlayer.MINING_GOAL_START;
            }
            case WOODCUTTING: {
                return VarPlayer.WOODCUTTING_GOAL_START;
            }
            case DEFENCE: {
                return VarPlayer.DEFENCE_GOAL_START;
            }
            case MAGIC: {
                return VarPlayer.MAGIC_GOAL_START;
            }
            case RANGED: {
                return VarPlayer.RANGED_GOAL_START;
            }
            case HITPOINTS: {
                return VarPlayer.HITPOINTS_GOAL_START;
            }
            case AGILITY: {
                return VarPlayer.AGILITY_GOAL_START;
            }
            case STRENGTH: {
                return VarPlayer.STRENGTH_GOAL_START;
            }
            case PRAYER: {
                return VarPlayer.PRAYER_GOAL_START;
            }
            case SLAYER: {
                return VarPlayer.SLAYER_GOAL_START;
            }
            case FISHING: {
                return VarPlayer.FISHING_GOAL_START;
            }
            case RUNECRAFT: {
                return VarPlayer.RUNECRAFT_GOAL_START;
            }
            case HERBLORE: {
                return VarPlayer.HERBLORE_GOAL_START;
            }
            case FIREMAKING: {
                return VarPlayer.FIREMAKING_GOAL_START;
            }
            case CONSTRUCTION: {
                return VarPlayer.CONSTRUCTION_GOAL_START;
            }
            case HUNTER: {
                return VarPlayer.HUNTER_GOAL_START;
            }
            case COOKING: {
                return VarPlayer.COOKING_GOAL_START;
            }
            case FARMING: {
                return VarPlayer.FARMING_GOAL_START;
            }
            case CRAFTING: {
                return VarPlayer.CRAFTING_GOAL_START;
            }
            case SMITHING: {
                return VarPlayer.SMITHING_GOAL_START;
            }
            case THIEVING: {
                return VarPlayer.THIEVING_GOAL_START;
            }
            case FLETCHING: {
                return VarPlayer.FLETCHING_GOAL_START;
            }
        }
        return null;
    }

    private static VarPlayer endGoalVarpForSkill(Skill skill) {
        switch (skill) {
            case ATTACK: {
                return VarPlayer.ATTACK_GOAL_END;
            }
            case MINING: {
                return VarPlayer.MINING_GOAL_END;
            }
            case WOODCUTTING: {
                return VarPlayer.WOODCUTTING_GOAL_END;
            }
            case DEFENCE: {
                return VarPlayer.DEFENCE_GOAL_END;
            }
            case MAGIC: {
                return VarPlayer.MAGIC_GOAL_END;
            }
            case RANGED: {
                return VarPlayer.RANGED_GOAL_END;
            }
            case HITPOINTS: {
                return VarPlayer.HITPOINTS_GOAL_END;
            }
            case AGILITY: {
                return VarPlayer.AGILITY_GOAL_END;
            }
            case STRENGTH: {
                return VarPlayer.STRENGTH_GOAL_END;
            }
            case PRAYER: {
                return VarPlayer.PRAYER_GOAL_END;
            }
            case SLAYER: {
                return VarPlayer.SLAYER_GOAL_END;
            }
            case FISHING: {
                return VarPlayer.FISHING_GOAL_END;
            }
            case RUNECRAFT: {
                return VarPlayer.RUNECRAFT_GOAL_END;
            }
            case HERBLORE: {
                return VarPlayer.HERBLORE_GOAL_END;
            }
            case FIREMAKING: {
                return VarPlayer.FIREMAKING_GOAL_END;
            }
            case CONSTRUCTION: {
                return VarPlayer.CONSTRUCTION_GOAL_END;
            }
            case HUNTER: {
                return VarPlayer.HUNTER_GOAL_END;
            }
            case COOKING: {
                return VarPlayer.COOKING_GOAL_END;
            }
            case FARMING: {
                return VarPlayer.FARMING_GOAL_END;
            }
            case CRAFTING: {
                return VarPlayer.CRAFTING_GOAL_END;
            }
            case SMITHING: {
                return VarPlayer.SMITHING_GOAL_END;
            }
            case THIEVING: {
                return VarPlayer.THIEVING_GOAL_END;
            }
            case FLETCHING: {
                return VarPlayer.FLETCHING_GOAL_END;
            }
        }
        return null;
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS)
    public void tickSkillTimes() {
        for (Skill skill : Skill.values()) {
            long skillExperience = skill == Skill.OVERALL ? this.client.getOverallExperience() : (long)this.client.getSkillExperience(skill);
            this.xpPauseState.tickXp(skill, skillExperience, this.xpTrackerConfig.pauseSkillAfter());
        }
        this.xpPauseState.tickLogout(this.xpTrackerConfig.pauseOnLogout(), !GameState.LOGIN_SCREEN.equals((Object)this.client.getGameState()));
        if (this.lastTickMillis == 0L) {
            this.lastTickMillis = System.currentTimeMillis();
            return;
        }
        long nowMillis = System.currentTimeMillis();
        long tickDelta = nowMillis - this.lastTickMillis;
        this.lastTickMillis = nowMillis;
        for (Skill skill : Skill.values()) {
            if (this.xpPauseState.isPaused(skill)) continue;
            this.xpState.tick(skill, tickDelta);
        }
        this.rebuildSkills();
    }

    private void rebuildSkills() {
        for (Skill skill : Skill.values()) {
            this.xpPanel.updateSkillExperience(false, this.xpPauseState.isPaused(skill), skill, this.xpState.getSkillSnapshot(skill));
        }
        this.xpPanel.updateTotal(this.xpState.getTotalSnapshot());
    }

    void pauseSkill(Skill skill, boolean pause) {
        if (pause ? this.xpPauseState.pauseSkill(skill) : this.xpPauseState.unpauseSkill(skill)) {
            this.xpPanel.updateSkillExperience(false, this.xpPauseState.isPaused(skill), skill, this.xpState.getSkillSnapshot(skill));
        }
    }

    void pauseAllSkills(boolean pause) {
        for (Skill skill : Skill.values()) {
            this.pauseSkill(skill, pause);
        }
    }
}

