/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.xptracker;

import java.util.HashMap;
import java.util.Map;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.client.plugins.xptracker.XpAction;
import net.runelite.client.plugins.xptracker.XpActionType;
import net.runelite.client.plugins.xptracker.XpSnapshotSingle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XpStateSingle {
    private static final Logger log = LoggerFactory.getLogger(XpStateSingle.class);
    private final Skill skill;
    private final Map<XpActionType, XpAction> actions = new HashMap<XpActionType, XpAction>();
    private final long startXp;
    private int xpGained = 0;
    private XpActionType actionType = XpActionType.EXPERIENCE;
    private long skillTime = 0L;
    private int startLevelExp = 0;
    private int endLevelExp = 0;

    XpAction getXpAction(XpActionType type) {
        this.actions.putIfAbsent(type, new XpAction());
        return this.actions.get((Object)type);
    }

    private long getCurrentXp() {
        return this.startXp + (long)this.xpGained;
    }

    private int getActionsHr() {
        return this.toHourly(this.getXpAction(this.actionType).getActions());
    }

    private int toHourly(int value) {
        return (int)(1.0 / ((double)this.getTimeElapsedInSeconds() / 3600.0) * (double)value);
    }

    private long getTimeElapsedInSeconds() {
        return Math.max(60L, this.skillTime / 1000L);
    }

    private int getXpRemaining() {
        return this.endLevelExp - (int)this.getCurrentXp();
    }

    private int getActionsRemaining() {
        XpAction action = this.getXpAction(this.actionType);
        if (action.isActionsHistoryInitialized()) {
            long xpRemaining = this.getXpRemaining() * action.getActionExps().length;
            long totalActionXp = 0L;
            for (int actionXp : action.getActionExps()) {
                totalActionXp += (long)actionXp;
            }
            if (totalActionXp > 0L) {
                long remainder = xpRemaining % totalActionXp;
                long quotient = xpRemaining / totalActionXp;
                return Math.toIntExact(quotient + (long)(remainder > 0L ? 1 : 0));
            }
        }
        return Integer.MAX_VALUE;
    }

    private double getSkillProgress() {
        double xpGained = this.getCurrentXp() - (long)this.startLevelExp;
        double xpGoal = this.endLevelExp - this.startLevelExp;
        return xpGained / xpGoal * 100.0;
    }

    private String getTimeTillLevel() {
        long seconds = this.getTimeElapsedInSeconds();
        if (seconds <= 0L || this.xpGained <= 0) {
            return "\u221e";
        }
        long remainingSeconds = (long)this.getXpRemaining() * seconds / (long)this.xpGained;
        long durationDays = remainingSeconds / 86400L;
        long durationHours = remainingSeconds % 86400L / 3600L;
        long durationMinutes = remainingSeconds % 3600L / 60L;
        long durationSeconds = remainingSeconds % 60L;
        if (durationDays > 1L) {
            return String.format("%d days %02d:%02d:%02d", durationDays, durationHours, durationMinutes, durationSeconds);
        }
        if (durationDays == 1L) {
            return String.format("1 day %02d:%02d:%02d", durationHours, durationMinutes, durationSeconds);
        }
        if (durationHours > 0L) {
            return String.format("%02d:%02d:%02d", durationHours, durationMinutes, durationSeconds);
        }
        return String.format("%02d:%02d", durationMinutes, durationSeconds);
    }

    int getXpHr() {
        return this.toHourly(this.xpGained);
    }

    boolean update(long currentXp, int goalStartXp, int goalEndXp) {
        if (this.startXp == -1L) {
            log.warn("Attempted to update skill state " + this.skill + " but was not initialized with current xp");
            return false;
        }
        long originalXp = (long)this.xpGained + this.startXp;
        int actionExp = (int)(currentXp - originalXp);
        if (actionExp == 0) {
            return false;
        }
        XpAction action = this.getXpAction(XpActionType.EXPERIENCE);
        if (action.isActionsHistoryInitialized()) {
            action.getActionExps()[action.getActionExpIndex()] = actionExp;
        } else {
            for (int i = 0; i < action.getActionExps().length; ++i) {
                action.getActionExps()[i] = actionExp;
            }
            action.setActionsHistoryInitialized(true);
        }
        action.setActionExpIndex((action.getActionExpIndex() + 1) % action.getActionExps().length);
        action.setActions(action.getActions() + 1);
        this.xpGained = (int)(currentXp - this.startXp);
        if (this.skill != Skill.OVERALL) {
            int currentLevel;
            this.startLevelExp = goalStartXp <= 0 || currentXp > (long)goalEndXp ? Experience.getXpForLevel(Experience.getLevelForXp((int)currentXp)) : goalStartXp;
            this.endLevelExp = goalEndXp <= 0 || currentXp > (long)goalEndXp ? ((currentLevel = Experience.getLevelForXp((int)currentXp)) + 1 <= 126 ? Experience.getXpForLevel(currentLevel + 1) : 200000000) : goalEndXp;
        }
        return true;
    }

    public void tick(long delta) {
        if (this.xpGained <= 0) {
            return;
        }
        this.skillTime += delta;
    }

    XpSnapshotSingle snapshot() {
        return XpSnapshotSingle.builder().startLevel(Experience.getLevelForXp(this.startLevelExp)).endLevel(Experience.getLevelForXp(this.endLevelExp)).xpGainedInSession(this.xpGained).xpRemainingToGoal(this.getXpRemaining()).xpPerHour(this.getXpHr()).skillProgressToGoal(this.getSkillProgress()).actionType(this.actionType).actionsInSession(this.getXpAction(this.actionType).getActions()).actionsRemainingToGoal(this.getActionsRemaining()).actionsPerHour(this.getActionsHr()).timeTillGoal(this.getTimeTillLevel()).startGoalXp(this.startLevelExp).endGoalXp(this.endLevelExp).build();
    }

    public XpStateSingle(Skill skill, long startXp) {
        this.skill = skill;
        this.startXp = startXp;
    }

    public long getStartXp() {
        return this.startXp;
    }

    public int getXpGained() {
        return this.xpGained;
    }

    public void setActionType(XpActionType actionType) {
        this.actionType = actionType;
    }
}

