/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.xptracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.xptracker.XpInfoBox;
import net.runelite.client.plugins.xptracker.XpSnapshotSingle;
import net.runelite.client.plugins.xptracker.XpTrackerConfig;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.LinkBrowser;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XpPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(XpPanel.class);
    private final Map<Skill, XpInfoBox> infoBoxes = new HashMap<Skill, XpInfoBox>();
    private final JLabel overallExpGained = new JLabel(XpInfoBox.htmlLabel("Gained: ", 0));
    private final JLabel overallExpHour = new JLabel(XpInfoBox.htmlLabel("Per hour: ", 0));
    private final JPanel overallPanel = new JPanel();
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();

    XpPanel(XpTrackerPlugin xpTrackerPlugin, XpTrackerConfig xpTrackerConfig, Client client2, SkillIconManager iconManager) {
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(layoutPanel, 1);
        layoutPanel.setLayout(boxLayout);
        this.add((Component)layoutPanel, "North");
        this.overallPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.overallPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.overallPanel.setLayout(new BorderLayout());
        this.overallPanel.setVisible(false);
        JMenuItem openXpTracker = new JMenuItem("Open online tracker");
        openXpTracker.addActionListener(e -> LinkBrowser.browse(XpPanel.buildXpTrackerUrl(client2.getLocalPlayer(), Skill.OVERALL)));
        JMenuItem reset = new JMenuItem("Reset All");
        reset.addActionListener(e -> xpTrackerPlugin.resetAndInitState());
        JMenuItem pauseAll = new JMenuItem("Pause All");
        pauseAll.addActionListener(e -> xpTrackerPlugin.pauseAllSkills(true));
        JMenuItem unpauseAll = new JMenuItem("Unpause All");
        unpauseAll.addActionListener(e -> xpTrackerPlugin.pauseAllSkills(false));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(openXpTracker);
        popupMenu.add(reset);
        popupMenu.add(pauseAll);
        popupMenu.add(unpauseAll);
        this.overallPanel.setComponentPopupMenu(popupMenu);
        JLabel overallIcon = new JLabel(new ImageIcon(iconManager.getSkillImage(Skill.OVERALL)));
        JPanel overallInfo = new JPanel();
        overallInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        overallInfo.setLayout(new GridLayout(2, 1));
        overallInfo.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.overallExpGained.setFont(FontManager.getRunescapeSmallFont());
        this.overallExpHour.setFont(FontManager.getRunescapeSmallFont());
        overallInfo.add(this.overallExpGained);
        overallInfo.add(this.overallExpHour);
        this.overallPanel.add((Component)overallIcon, "West");
        this.overallPanel.add((Component)overallInfo, "Center");
        JPanel infoBoxPanel = new JPanel();
        infoBoxPanel.setLayout(new BoxLayout(infoBoxPanel, 1));
        layoutPanel.add(this.overallPanel);
        layoutPanel.add(infoBoxPanel);
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) break;
            this.infoBoxes.put(skill, new XpInfoBox(xpTrackerPlugin, xpTrackerConfig, client2, infoBoxPanel, skill, iconManager));
        }
        this.errorPanel.setContent("Exp trackers", "You have not gained experience yet.");
        this.add(this.errorPanel);
    }

    static String buildXpTrackerUrl(Actor player, Skill skill) {
        if (player == null) {
            return "";
        }
        return new HttpUrl.Builder().scheme("https").host("runelite.net").addPathSegment("xp").addPathSegment("show").addPathSegment(skill.getName().toLowerCase()).addPathSegment(player.getName()).addPathSegment("1week").addPathSegment("now").build().toString();
    }

    void resetAllInfoBoxes() {
        this.infoBoxes.forEach((skill, xpInfoBox) -> xpInfoBox.reset());
    }

    void resetSkill(Skill skill) {
        XpInfoBox xpInfoBox = this.infoBoxes.get((Object)skill);
        if (xpInfoBox != null) {
            xpInfoBox.reset();
        }
    }

    void updateSkillExperience(boolean updated, boolean paused, Skill skill, XpSnapshotSingle xpSnapshotSingle) {
        XpInfoBox xpInfoBox = this.infoBoxes.get((Object)skill);
        if (xpInfoBox != null) {
            xpInfoBox.update(updated, paused, xpSnapshotSingle);
        }
    }

    void updateTotal(XpSnapshotSingle xpSnapshotTotal) {
        if (xpSnapshotTotal.getXpGainedInSession() > 0 && !this.overallPanel.isVisible()) {
            this.overallPanel.setVisible(true);
            this.remove(this.errorPanel);
        } else if (xpSnapshotTotal.getXpGainedInSession() == 0 && this.overallPanel.isVisible()) {
            this.overallPanel.setVisible(false);
            this.add(this.errorPanel);
        }
        SwingUtilities.invokeLater(() -> this.rebuildAsync(xpSnapshotTotal));
    }

    private void rebuildAsync(XpSnapshotSingle xpSnapshotTotal) {
        this.overallExpGained.setText(XpInfoBox.htmlLabel("Gained: ", xpSnapshotTotal.getXpGainedInSession()));
        this.overallExpHour.setText(XpInfoBox.htmlLabel("Per hour: ", xpSnapshotTotal.getXpPerHour()));
    }
}

