/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.worldmap;

import com.google.inject.Inject;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.ExperienceChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.AgilityShortcut;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.worldmap.AgilityShortcutPoint;
import net.runelite.client.plugins.worldmap.FairyRingLocation;
import net.runelite.client.plugins.worldmap.FairyRingPoint;
import net.runelite.client.plugins.worldmap.FarmingPatchLocation;
import net.runelite.client.plugins.worldmap.FarmingPatchPoint;
import net.runelite.client.plugins.worldmap.MinigameLocation;
import net.runelite.client.plugins.worldmap.MinigamePoint;
import net.runelite.client.plugins.worldmap.QuestStartLocation;
import net.runelite.client.plugins.worldmap.QuestStartPoint;
import net.runelite.client.plugins.worldmap.RareTreeLocation;
import net.runelite.client.plugins.worldmap.RareTreePoint;
import net.runelite.client.plugins.worldmap.TeleportLocationData;
import net.runelite.client.plugins.worldmap.TeleportPoint;
import net.runelite.client.plugins.worldmap.TransportationPoint;
import net.runelite.client.plugins.worldmap.TransportationPointLocation;
import net.runelite.client.plugins.worldmap.WorldMapConfig;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="World Map", description="Enhance the world map to display additional information", tags={"agility", "fairy", "farming", "rings", "teleports"})
public class WorldMapPlugin
extends Plugin {
    static final BufferedImage BLANK_ICON;
    private static final BufferedImage FAIRY_TRAVEL_ICON;
    private static final BufferedImage NOPE_ICON;
    static final String CONFIG_KEY = "worldmap";
    static final String CONFIG_KEY_FAIRY_RING_TOOLTIPS = "fairyRingTooltips";
    static final String CONFIG_KEY_FAIRY_RING_ICON = "fairyRingIcon";
    static final String CONFIG_KEY_AGILITY_SHORTCUT_TOOLTIPS = "agilityShortcutTooltips";
    static final String CONFIG_KEY_AGILITY_SHORTCUT_LEVEL_ICON = "agilityShortcutIcon";
    static final String CONFIG_KEY_NORMAL_TELEPORT_ICON = "standardSpellbookIcon";
    static final String CONFIG_KEY_ANCIENT_TELEPORT_ICON = "ancientSpellbookIcon";
    static final String CONFIG_KEY_LUNAR_TELEPORT_ICON = "lunarSpellbookIcon";
    static final String CONFIG_KEY_ARCEUUS_TELEPORT_ICON = "arceuusSpellbookIcon";
    static final String CONFIG_KEY_JEWELLERY_TELEPORT_ICON = "jewelleryIcon";
    static final String CONFIG_KEY_SCROLL_TELEPORT_ICON = "scrollIcon";
    static final String CONFIG_KEY_MISC_TELEPORT_ICON = "miscellaneousTeleportIcon";
    static final String CONFIG_KEY_QUEST_START_TOOLTIPS = "questStartTooltips";
    static final String CONFIG_KEY_MINIGAME_TOOLTIP = "minigameTooltip";
    static final String CONFIG_KEY_FARMING_PATCH_TOOLTIPS = "farmingpatchTooltips";
    static final String CONFIG_KEY_RARE_TREE_TOOLTIPS = "rareTreeTooltips";
    static final String CONFIG_KEY_RARE_TREE_LEVEL_ICON = "rareTreeIcon";
    static final String CONFIG_KEY_TRANSPORATION_TELEPORT_TOOLTIPS = "transportationTooltips";
    @Inject
    private Client client;
    @Inject
    private WorldMapConfig config;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private int agilityLevel = 0;
    private int woodcuttingLevel = 0;

    @Provides
    WorldMapConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(WorldMapConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.agilityLevel = this.client.getRealSkillLevel(Skill.AGILITY);
        this.woodcuttingLevel = this.client.getRealSkillLevel(Skill.WOODCUTTING);
        this.updateShownIcons();
    }

    @Override
    protected void shutDown() throws Exception {
        this.worldMapPointManager.removeIf(FairyRingPoint.class::isInstance);
        this.worldMapPointManager.removeIf(AgilityShortcutPoint.class::isInstance);
        this.worldMapPointManager.removeIf(QuestStartPoint.class::isInstance);
        this.worldMapPointManager.removeIf(TeleportPoint.class::isInstance);
        this.worldMapPointManager.removeIf(TransportationPoint.class::isInstance);
        this.worldMapPointManager.removeIf(MinigamePoint.class::isInstance);
        this.worldMapPointManager.removeIf(FarmingPatchPoint.class::isInstance);
        this.worldMapPointManager.removeIf(RareTreePoint.class::isInstance);
        this.agilityLevel = 0;
        this.woodcuttingLevel = 0;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_KEY)) {
            return;
        }
        this.updateShownIcons();
    }

    @Subscribe
    public void onExperienceChanged(ExperienceChanged event) {
        int newWoodcutLevel;
        int newAgilityLevel;
        if (event.getSkill() == Skill.AGILITY && (newAgilityLevel = Experience.getLevelForXp(this.client.getSkillExperience(Skill.AGILITY))) != this.agilityLevel) {
            this.agilityLevel = newAgilityLevel;
            this.updateAgilityIcons();
        }
        if (event.getSkill() == Skill.WOODCUTTING && (newWoodcutLevel = Experience.getLevelForXp(this.client.getSkillExperience(Skill.WOODCUTTING))) != this.woodcuttingLevel) {
            this.woodcuttingLevel = newWoodcutLevel;
            this.updateRareTreeIcons();
        }
    }

    private void updateAgilityIcons() {
        block3: {
            block2: {
                this.worldMapPointManager.removeIf(AgilityShortcutPoint.class::isInstance);
                if (this.config.agilityShortcutLevelIcon()) break block2;
                if (!this.config.agilityShortcutTooltips()) break block3;
            }
            Arrays.stream(AgilityShortcut.values()).filter(value -> value.getWorldMapLocation() != null).map(value -> new AgilityShortcutPoint((AgilityShortcut)((Object)value), this.agilityLevel > 0 && this.config.agilityShortcutLevelIcon() && value.getLevel() > this.agilityLevel ? NOPE_ICON : BLANK_ICON, this.config.agilityShortcutTooltips())).forEach(this.worldMapPointManager::add);
        }
    }

    private void updateRareTreeIcons() {
        this.worldMapPointManager.removeIf(RareTreePoint.class::isInstance);
        if (this.config.rareTreeLevelIcon() || this.config.rareTreeTooltips()) {
            Arrays.stream(RareTreeLocation.values()).forEach(rareTree -> Arrays.stream(rareTree.getLocations()).map(point -> new RareTreePoint((WorldPoint)point, rareTree.getTooltip(), this.woodcuttingLevel > 0 && this.config.rareTreeLevelIcon() && rareTree.getLevelReq() > this.woodcuttingLevel ? NOPE_ICON : BLANK_ICON, this.config.rareTreeTooltips())).forEach(this.worldMapPointManager::add));
        }
    }

    private void updateShownIcons() {
        block8: {
            block7: {
                this.updateAgilityIcons();
                this.updateRareTreeIcons();
                this.worldMapPointManager.removeIf(FairyRingPoint.class::isInstance);
                if (this.config.fairyRingIcon()) break block7;
                if (!this.config.fairyRingTooltips()) break block8;
            }
            Arrays.stream(FairyRingLocation.values()).map(value -> new FairyRingPoint((FairyRingLocation)((Object)value), this.config.fairyRingIcon() ? FAIRY_TRAVEL_ICON : BLANK_ICON, this.config.fairyRingTooltips())).forEach(this.worldMapPointManager::add);
        }
        this.worldMapPointManager.removeIf(MinigamePoint.class::isInstance);
        if (this.config.minigameTooltip()) {
            Arrays.stream(MinigameLocation.values()).map(value -> new MinigamePoint((MinigameLocation)((Object)value), BLANK_ICON)).forEach(this.worldMapPointManager::add);
        }
        this.worldMapPointManager.removeIf(QuestStartPoint.class::isInstance);
        if (this.config.questStartTooltips()) {
            Arrays.stream(QuestStartLocation.values()).map(value -> new QuestStartPoint((QuestStartLocation)((Object)value), BLANK_ICON)).forEach(this.worldMapPointManager::add);
        }
        this.worldMapPointManager.removeIf(TransportationPoint.class::isInstance);
        if (this.config.transportationTeleportTooltips()) {
            Arrays.stream(TransportationPointLocation.values()).map(value -> new TransportationPoint((TransportationPointLocation)((Object)value), BLANK_ICON)).forEach(this.worldMapPointManager::add);
        }
        this.worldMapPointManager.removeIf(FarmingPatchPoint.class::isInstance);
        if (this.config.farmingPatchTooltips()) {
            Arrays.stream(FarmingPatchLocation.values()).forEach(location -> Arrays.stream(location.getLocations()).map(point -> new FarmingPatchPoint((WorldPoint)point, location.getTooltip(), BLANK_ICON)).forEach(this.worldMapPointManager::add));
        }
        this.worldMapPointManager.removeIf(TeleportPoint.class::isInstance);
        Arrays.stream(TeleportLocationData.values()).filter(data -> {
            switch (data.getType()) {
                case NORMAL_MAGIC: {
                    return this.config.normalTeleportIcon();
                }
                case ANCIENT_MAGICKS: {
                    return this.config.ancientTeleportIcon();
                }
                case LUNAR_MAGIC: {
                    return this.config.lunarTeleportIcon();
                }
                case ARCEUUS_MAGIC: {
                    return this.config.arceuusTeleportIcon();
                }
                case JEWELLERY: {
                    return this.config.jewelleryTeleportIcon();
                }
                case SCROLL: {
                    return this.config.scrollTeleportIcon();
                }
                case OTHER: {
                    return this.config.miscellaneousTeleportIcon();
                }
            }
            return false;
        }).map(TeleportPoint::new).forEach(this.worldMapPointManager::add);
    }

    static {
        int iconBufferSize = 17;
        BLANK_ICON = new BufferedImage(17, 17, 2);
        FAIRY_TRAVEL_ICON = new BufferedImage(17, 17, 2);
        BufferedImage fairyTravelIcon = ImageUtil.getResourceStreamFromClass(WorldMapPlugin.class, "fairy_ring_travel.png");
        FAIRY_TRAVEL_ICON.getGraphics().drawImage(fairyTravelIcon, 1, 1, null);
        NOPE_ICON = new BufferedImage(17, 17, 2);
        BufferedImage nopeImage = ImageUtil.getResourceStreamFromClass(WorldMapPlugin.class, "nope_icon.png");
        NOPE_ICON.getGraphics().drawImage(nopeImage, 1, 1, null);
    }
}

