/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.worldhopper;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.plugins.worldhopper.SubscriptionFilterMode;
import net.runelite.client.plugins.worldhopper.WorldHopperPlugin;
import net.runelite.client.plugins.worldhopper.WorldTableHeader;
import net.runelite.client.plugins.worldhopper.WorldTableRow;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorldSwitcherPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(WorldSwitcherPanel.class);
    private static final Color ODD_ROW = new Color(44, 44, 44);
    private static final int WORLD_COLUMN_WIDTH = 60;
    private static final int PLAYERS_COLUMN_WIDTH = 40;
    private static final int PING_COLUMN_WIDTH = 47;
    private final JPanel listContainer = new JPanel();
    private WorldTableHeader worldHeader;
    private WorldTableHeader playersHeader;
    private WorldTableHeader activityHeader;
    private WorldTableHeader pingHeader;
    private WorldOrder orderIndex = WorldOrder.WORLD;
    private boolean ascendingOrder = true;
    private ArrayList<WorldTableRow> rows = new ArrayList();
    private WorldHopperPlugin plugin;
    private SubscriptionFilterMode filterMode;

    WorldSwitcherPanel(WorldHopperPlugin plugin) {
        this.plugin = plugin;
        this.setBorder(null);
        this.setLayout(new DynamicGridLayout(0, 1));
        JPanel headerContainer = this.buildHeader();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(headerContainer);
        this.add(this.listContainer);
    }

    void switchCurrentHighlight(int newWorld, int lastWorld) {
        for (WorldTableRow row : this.rows) {
            if (row.getWorld().getId() == newWorld) {
                row.recolour(true);
                continue;
            }
            if (row.getWorld().getId() != lastWorld) continue;
            row.recolour(false);
        }
    }

    void updateListData(Map<Integer, Integer> worldData) {
        for (WorldTableRow worldTableRow : this.rows) {
            World world = worldTableRow.getWorld();
            Integer playerCount = worldData.get(world.getId());
            if (playerCount == null) continue;
            worldTableRow.updatePlayerCount(playerCount);
        }
        if (this.orderIndex == WorldOrder.PLAYERS) {
            this.updateList();
        }
    }

    void updatePing(int world, int ping) {
        for (WorldTableRow worldTableRow : this.rows) {
            if (worldTableRow.getWorld().getId() != world) continue;
            worldTableRow.setPing(ping);
            if (this.orderIndex != WorldOrder.PING) break;
            this.updateList();
            break;
        }
    }

    void hidePing() {
        for (WorldTableRow worldTableRow : this.rows) {
            worldTableRow.hidePing();
        }
    }

    void showPing() {
        for (WorldTableRow worldTableRow : this.rows) {
            worldTableRow.showPing();
        }
    }

    void updateList() {
        this.rows.sort((r1, r2) -> {
            switch (this.orderIndex) {
                case PING: {
                    return Integer.compare(r1.getPing(), r2.getPing()) * (this.ascendingOrder ? 1 : -1);
                }
                case WORLD: {
                    return Integer.compare(r1.getWorld().getId(), r2.getWorld().getId()) * (this.ascendingOrder ? 1 : -1);
                }
                case PLAYERS: {
                    return Integer.compare(r1.getUpdatedPlayerCount(), r2.getUpdatedPlayerCount()) * (this.ascendingOrder ? 1 : -1);
                }
                case ACTIVITY: {
                    return r1.getWorld().getActivity().compareTo(r2.getWorld().getActivity()) * -1 * (this.ascendingOrder ? 1 : -1);
                }
            }
            return 0;
        });
        if (this.orderIndex == WorldOrder.ACTIVITY) {
            this.rows.sort((r1, r2) -> r1.getWorld().getActivity().equals("-") ? 1 : -1);
        }
        this.rows.sort((r1, r2) -> {
            boolean b1 = this.plugin.isFavorite(r1.getWorld());
            boolean b2 = this.plugin.isFavorite(r2.getWorld());
            return Boolean.compare(b2, b1);
        });
        this.listContainer.removeAll();
        for (int i = 0; i < this.rows.size(); ++i) {
            WorldTableRow row = this.rows.get(i);
            row.setBackground(i % 2 == 0 ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
            this.listContainer.add(row);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    void updateFavoriteMenu(int world, boolean favorite) {
        for (WorldTableRow row : this.rows) {
            if (row.getWorld().getId() != world) continue;
            row.setFavoriteMenu(favorite);
        }
    }

    void resetAllFavoriteMenus() {
        for (WorldTableRow row : this.rows) {
            row.setFavoriteMenu(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void populate(List<World> worlds) {
        this.rows.clear();
        int i = 0;
        while (true) {
            block6: {
                if (i >= worlds.size()) {
                    this.updateList();
                    return;
                }
                World world = worlds.get(i);
                switch (this.filterMode) {
                    case FREE: {
                        if (!world.getTypes().contains((Object)WorldType.MEMBERS)) break;
                        break block6;
                    }
                    case MEMBERS: {
                        if (!world.getTypes().contains((Object)WorldType.MEMBERS)) break block6;
                    }
                }
                this.rows.add(this.buildRow(world, i % 2 == 0, world.getId() == this.plugin.getCurrentWorld() && this.plugin.getLastWorld() != 0, this.plugin.isFavorite(world)));
            }
            ++i;
        }
    }

    private void orderBy(WorldOrder order) {
        this.pingHeader.highlight(false, this.ascendingOrder);
        this.worldHeader.highlight(false, this.ascendingOrder);
        this.playersHeader.highlight(false, this.ascendingOrder);
        this.activityHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case PING: {
                this.pingHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case WORLD: {
                this.worldHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case PLAYERS: {
                this.playersHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case ACTIVITY: {
                this.activityHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderIndex = order;
        this.updateList();
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel(new BorderLayout());
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        this.pingHeader = new WorldTableHeader("Ping", this.orderIndex == WorldOrder.PING, this.ascendingOrder, this.plugin::refresh);
        this.pingHeader.setPreferredSize(new Dimension(47, 0));
        this.pingHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.PING || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.PING);
            }
        });
        this.worldHeader = new WorldTableHeader("World", this.orderIndex == WorldOrder.WORLD, this.ascendingOrder, this.plugin::refresh);
        this.worldHeader.setPreferredSize(new Dimension(60, 0));
        this.worldHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.WORLD || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.WORLD);
            }
        });
        this.playersHeader = new WorldTableHeader("#", this.orderIndex == WorldOrder.PLAYERS, this.ascendingOrder, this.plugin::refresh);
        this.playersHeader.setPreferredSize(new Dimension(40, 0));
        this.playersHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.PLAYERS || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.PLAYERS);
            }
        });
        this.activityHeader = new WorldTableHeader("Activity", this.orderIndex == WorldOrder.ACTIVITY, this.ascendingOrder, this.plugin::refresh);
        this.activityHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.ACTIVITY || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.ACTIVITY);
            }
        });
        leftSide.add((Component)this.worldHeader, "West");
        leftSide.add((Component)this.playersHeader, "Center");
        rightSide.add((Component)this.activityHeader, "Center");
        rightSide.add((Component)this.pingHeader, "East");
        header.add((Component)leftSide, "West");
        header.add((Component)rightSide, "Center");
        return header;
    }

    private WorldTableRow buildRow(World world, boolean stripe, boolean current, boolean favorite) {
        WorldTableRow row = new WorldTableRow(world, current, favorite, world1 -> this.plugin.hopTo((World)world1), (world12, add) -> {
            if (add.booleanValue()) {
                this.plugin.addToFavorites((World)world12);
            } else {
                this.plugin.removeFromFavorites((World)world12);
            }
            this.updateList();
        });
        row.setBackground(stripe ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
        return row;
    }

    void setFilterMode(SubscriptionFilterMode filterMode) {
        this.filterMode = filterMode;
    }

    private static enum WorldOrder {
        WORLD,
        PLAYERS,
        ACTIVITY,
        PING;

    }
}

