/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.worldhopper;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.ChatPlayer;
import net.runelite.api.ClanMember;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Varbits;
import net.runelite.api.World;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.PlayerMenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WorldListLoad;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.worldhopper.WorldHopperConfig;
import net.runelite.client.plugins.worldhopper.WorldSwitcherPanel;
import net.runelite.client.plugins.worldhopper.ping.Ping;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ExecutorServiceExceptionLogger;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.Text;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldClient;
import net.runelite.http.api.worlds.WorldResult;
import net.runelite.http.api.worlds.WorldType;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldHopperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WorldHopperPlugin.class);
    private static final int WORLD_FETCH_TIMER = 10;
    private static final int WORLD_PING_TIMER = 10;
    private static final int REFRESH_THROTTLE = 60000;
    private static final int TICK_THROTTLE = (int)Duration.ofMinutes(10L).toMillis();
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    private static final String HOP_TO = "Hop-to";
    private static final String KICK_OPTION = "Kick";
    private static final ImmutableList<String> BEFORE_OPTIONS = ImmutableList.of("Add friend", "Remove friend", "Kick");
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of("Message");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ScheduledExecutorService executorService;
    @Inject
    private WorldHopperConfig config;
    private ScheduledExecutorService hopperExecutorService;
    private NavigationButton navButton;
    private WorldSwitcherPanel panel;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;
    private int lastWorld;
    private int favoriteWorld1;
    private int favoriteWorld2;
    private ScheduledFuture<?> worldResultFuture;
    private ScheduledFuture<?> pingFuture;
    private WorldResult worldResult;
    private Instant lastFetch;
    private boolean firstRun;
    private final HotkeyListener previousKeyListener = new HotkeyListener(() -> this.config.previousKey()){

        @Override
        public void hotkeyPressed() {
            WorldHopperPlugin.this.hop(true);
        }
    };
    private final HotkeyListener nextKeyListener = new HotkeyListener(() -> this.config.nextKey()){

        @Override
        public void hotkeyPressed() {
            WorldHopperPlugin.this.hop(false);
        }
    };

    @Provides
    WorldHopperConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(WorldHopperConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startUp() throws Exception {
        this.firstRun = true;
        this.keyManager.registerKeyListener(this.previousKeyListener);
        this.keyManager.registerKeyListener(this.nextKeyListener);
        this.panel = new WorldSwitcherPanel(this);
        Class<ImageIO> clazz = ImageIO.class;
        synchronized (ImageIO.class) {
            BufferedImage icon = ImageIO.read(this.getClass().getResourceAsStream("icon.png"));
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.navButton = NavigationButton.builder().tooltip("World Switcher").icon(icon).priority(3).panel(this.panel).build();
            if (this.config.showSidebar()) {
                this.clientToolbar.addNavigation(this.navButton);
            }
            this.panel.setFilterMode(this.config.subscriptionFilter());
            this.worldResultFuture = this.executorService.scheduleAtFixedRate(this::tick, 0L, 10L, TimeUnit.MINUTES);
            this.hopperExecutorService = new ExecutorServiceExceptionLogger(Executors.newSingleThreadScheduledExecutor());
            this.pingFuture = this.hopperExecutorService.scheduleAtFixedRate(this::pingWorlds, 10L, 10L, TimeUnit.MINUTES);
            return;
        }
    }

    @Override
    protected void shutDown() throws Exception {
        this.pingFuture.cancel(true);
        this.pingFuture = null;
        this.keyManager.unregisterKeyListener(this.previousKeyListener);
        this.keyManager.unregisterKeyListener(this.nextKeyListener);
        this.worldResultFuture.cancel(true);
        this.worldResultFuture = null;
        this.worldResult = null;
        this.lastFetch = null;
        this.clientToolbar.removeNavigation(this.navButton);
        this.hopperExecutorService.shutdown();
        this.hopperExecutorService = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("worldhopper")) {
            switch (event.getKey()) {
                case "showSidebar": {
                    if (this.config.showSidebar()) {
                        this.clientToolbar.addNavigation(this.navButton);
                        break;
                    }
                    this.clientToolbar.removeNavigation(this.navButton);
                    break;
                }
                case "ping": {
                    if (this.config.ping()) {
                        SwingUtilities.invokeLater(() -> this.panel.showPing());
                        break;
                    }
                    SwingUtilities.invokeLater(() -> this.panel.hidePing());
                    break;
                }
                case "subscriptionFilter": {
                    this.panel.setFilterMode(this.config.subscriptionFilter());
                    this.updateList();
                }
            }
        }
    }

    private void setFavoriteConfig(int world) {
        this.configManager.setConfiguration("worldhopper", "favorite_" + world, true);
    }

    private boolean isFavoriteConfig(int world) {
        Boolean favorite = this.configManager.getConfiguration("worldhopper", "favorite_" + world, Boolean.class);
        return favorite != null && favorite != false;
    }

    private void clearFavoriteConfig(int world) {
        this.configManager.unsetConfiguration("worldhopper", "favorite_" + world);
        this.panel.resetAllFavoriteMenus();
    }

    boolean isFavorite(net.runelite.http.api.worlds.World world) {
        int id = world.getId();
        return id == this.favoriteWorld1 || id == this.favoriteWorld2 || this.isFavoriteConfig(id);
    }

    int getCurrentWorld() {
        return this.client.getWorld();
    }

    void hopTo(net.runelite.http.api.worlds.World world) {
        this.hop(world.getId());
    }

    void addToFavorites(net.runelite.http.api.worlds.World world) {
        log.debug("Adding world {} to favorites", (Object)world.getId());
        this.setFavoriteConfig(world.getId());
        this.panel.updateFavoriteMenu(world.getId(), true);
    }

    void removeFromFavorites(net.runelite.http.api.worlds.World world) {
        log.debug("Removing world {} from favorites", (Object)world.getId());
        this.clearFavoriteConfig(world.getId());
        this.panel.updateFavoriteMenu(world.getId(), false);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        block3: {
            block2: {
                int old1 = this.favoriteWorld1;
                int old2 = this.favoriteWorld2;
                this.favoriteWorld1 = this.client.getVar(Varbits.WORLDHOPPER_FAVROITE_1);
                this.favoriteWorld2 = this.client.getVar(Varbits.WORLDHOPPER_FAVROITE_2);
                if (old1 != this.favoriteWorld1) break block2;
                if (old2 == this.favoriteWorld2) break block3;
            }
            SwingUtilities.invokeLater(this.panel::updateList);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int groupId = WidgetInfo.TO_GROUP(event.getActionParam1());
        String option = event.getOption();
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() || groupId == WidgetInfo.CLAN_CHAT.getGroupId()) {
            boolean after;
            if (AFTER_OPTIONS.contains(option)) {
                after = true;
            } else if (BEFORE_OPTIONS.contains(option)) {
                after = false;
            } else {
                return;
            }
            ChatPlayer player = this.getChatPlayerFromName(event.getTarget());
            if (player == null || player.getWorld() == 0 || player.getWorld() == this.client.getWorld() || this.worldResult == null) {
                return;
            }
            net.runelite.http.api.worlds.World currentWorld = this.worldResult.findWorld(this.client.getWorld());
            net.runelite.http.api.worlds.World targetWorld = this.worldResult.findWorld(player.getWorld());
            if (targetWorld == null || currentWorld == null || !currentWorld.getTypes().contains((Object)WorldType.PVP) && targetWorld.getTypes().contains((Object)WorldType.PVP)) {
                return;
            }
            MenuEntry hopTo = new MenuEntry();
            hopTo.setOption(HOP_TO);
            hopTo.setTarget(event.getTarget());
            hopTo.setType(MenuAction.RUNELITE.getId());
            hopTo.setParam0(event.getActionParam0());
            hopTo.setParam1(event.getActionParam1());
            this.insertMenuEntry(hopTo, this.client.getMenuEntries(), after);
        }
    }

    private void insertMenuEntry(MenuEntry newEntry, MenuEntry[] entries, boolean after) {
        Object[] newMenu = ObjectArrays.concat(entries, newEntry);
        if (after) {
            int menuEntryCount = newMenu.length;
            ArrayUtils.swap(newMenu, menuEntryCount - 1, menuEntryCount - 2);
        }
        this.client.setMenuEntries((MenuEntry[])newMenu);
    }

    @Subscribe
    public void onPlayerMenuOptionClicked(PlayerMenuOptionClicked event) {
        if (!event.getMenuOption().equals(HOP_TO)) {
            return;
        }
        ChatPlayer player = this.getChatPlayerFromName(event.getMenuTarget());
        if (player != null) {
            this.hop(player.getWorld());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.config.showSidebar() && gameStateChanged.getGameState() == GameState.LOGGED_IN && this.lastWorld != this.client.getWorld()) {
            int newWorld = this.client.getWorld();
            this.panel.switchCurrentHighlight(newWorld, this.lastWorld);
            this.lastWorld = newWorld;
        }
    }

    @Subscribe
    public void onWorldListLoad(WorldListLoad worldListLoad) {
        if (!this.config.showSidebar()) {
            return;
        }
        HashMap<Integer, Integer> worldData = new HashMap<Integer, Integer>();
        for (World w : worldListLoad.getWorlds()) {
            worldData.put(w.getId(), w.getPlayerCount());
        }
        this.panel.updateListData(worldData);
        this.lastFetch = Instant.now();
    }

    private void tick() {
        Instant now = Instant.now();
        if (this.lastFetch != null && now.toEpochMilli() - this.lastFetch.toEpochMilli() < (long)TICK_THROTTLE) {
            log.debug("Throttling world refresh tick");
            return;
        }
        this.fetchWorlds();
        if (this.firstRun) {
            this.firstRun = false;
            this.hopperExecutorService.execute(this::pingWorlds);
        }
    }

    void refresh() {
        Instant now = Instant.now();
        if (this.lastFetch != null && now.toEpochMilli() - this.lastFetch.toEpochMilli() < 60000L) {
            log.debug("Throttling world refresh");
            return;
        }
        this.fetchWorlds();
    }

    private void fetchWorlds() {
        log.debug("Fetching worlds");
        try {
            WorldResult worldResult = new WorldClient().lookupWorlds();
            if (worldResult != null) {
                worldResult.getWorlds().sort(Comparator.comparingInt(net.runelite.http.api.worlds.World::getId));
                this.worldResult = worldResult;
                this.lastFetch = Instant.now();
                this.updateList();
            }
        }
        catch (IOException ex) {
            log.warn("Error looking up worlds", ex);
        }
    }

    private void updateList() {
        SwingUtilities.invokeLater(() -> this.panel.populate(this.worldResult.getWorlds()));
    }

    private void hop(boolean previous) {
        net.runelite.http.api.worlds.World world;
        Object types;
        if (this.worldResult == null || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        net.runelite.http.api.worlds.World currentWorld = this.worldResult.findWorld(this.client.getWorld());
        if (currentWorld == null) {
            return;
        }
        Object currentWorldTypes = currentWorld.getTypes().clone();
        if (this.config.quickhopOutOfDanger()) {
            ((AbstractCollection)currentWorldTypes).remove((Object)WorldType.PVP);
            ((AbstractCollection)currentWorldTypes).remove((Object)WorldType.HIGH_RISK);
        }
        ((AbstractCollection)currentWorldTypes).remove((Object)WorldType.BOUNTY);
        ((AbstractCollection)currentWorldTypes).remove((Object)WorldType.SKILL_TOTAL);
        ((AbstractCollection)currentWorldTypes).remove((Object)WorldType.LAST_MAN_STANDING);
        List<net.runelite.http.api.worlds.World> worlds = this.worldResult.getWorlds();
        int worldIdx = worlds.indexOf(currentWorld);
        int totalLevel = this.client.getTotalLevel();
        do {
            if (previous) {
                if (--worldIdx < 0) {
                    worldIdx = worlds.size() - 1;
                }
            } else if (++worldIdx >= worlds.size()) {
                worldIdx = 0;
            }
            world = worlds.get(worldIdx);
            types = world.getTypes().clone();
            ((AbstractCollection)types).remove((Object)WorldType.BOUNTY);
            ((AbstractCollection)types).remove((Object)WorldType.LAST_MAN_STANDING);
            if (!((AbstractCollection)types).contains((Object)WorldType.SKILL_TOTAL)) continue;
            try {
                int totalRequirement = Integer.parseInt(world.getActivity().substring(0, world.getActivity().indexOf(" ")));
                if (totalLevel < totalRequirement) continue;
                ((AbstractCollection)types).remove((Object)WorldType.SKILL_TOTAL);
            }
            catch (NumberFormatException ex) {
                log.warn("Failed to parse total level requirement for target world", ex);
            }
        } while (!((AbstractSet)currentWorldTypes).equals(types) && world != currentWorld);
        if (world == currentWorld) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Couldn't find a world to quick-hop to.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        } else {
            this.hop(world.getId());
        }
    }

    private void hop(int worldId) {
        net.runelite.http.api.worlds.World world = this.worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes(world.getTypes()));
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        if (this.config.showWorldHopMessage()) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quick-hopping to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        }
        this.quickHopTargetWorld = rsWorld;
        this.displaySwitcherAttempts = 0;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.resetQuickHopper();
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.resetQuickHopper();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("Please finish what you're doing before using the World Switcher.")) {
            this.resetQuickHopper();
        }
    }

    private void resetQuickHopper() {
        this.displaySwitcherAttempts = 0;
        this.quickHopTargetWorld = null;
    }

    private ChatPlayer getChatPlayerFromName(String name) {
        Friend[] friends;
        String cleanName = Text.removeTags(name);
        ClanMember[] clanMembers = this.client.getClanMembers();
        if (clanMembers != null) {
            for (ClanMember clanMember : clanMembers) {
                if (clanMember == null || !clanMember.getUsername().equals(cleanName)) continue;
                return clanMember;
            }
        }
        if ((friends = this.client.getFriends()) != null) {
            for (Friend friend : friends) {
                if (friend == null || !friend.getName().equals(cleanName)) continue;
                return friend;
            }
        }
        return null;
    }

    private void pingWorlds() {
        if (this.worldResult == null || !this.config.showSidebar() || !this.config.ping()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (net.runelite.http.api.worlds.World world : this.worldResult.getWorlds()) {
            int ping = Ping.ping(world);
            SwingUtilities.invokeLater(() -> this.panel.updatePing(world.getId(), ping));
        }
        stopwatch.stop();
        log.debug("Done pinging worlds in {}", (Object)stopwatch.elapsed());
    }

    public int getLastWorld() {
        return this.lastWorld;
    }
}

