/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.woodcutting;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.woodcutting.Axe;
import net.runelite.client.plugins.woodcutting.WoodcuttingConfig;
import net.runelite.client.plugins.woodcutting.WoodcuttingPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class WoodcuttingTreesOverlay
extends Overlay {
    private final Client client;
    private final WoodcuttingConfig config;
    private final ItemManager itemManager;
    private final WoodcuttingPlugin plugin;

    @Inject
    private WoodcuttingTreesOverlay(Client client2, WoodcuttingConfig config, ItemManager itemManager, WoodcuttingPlugin plugin) {
        this.client = client2;
        this.config = config;
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getSession() == null || !this.config.showRedwoodTrees()) {
            return null;
        }
        Axe axe = this.plugin.getAxe();
        if (axe == null) {
            return null;
        }
        for (GameObject treeObject : this.plugin.getTreeObjects()) {
            if (treeObject.getWorldLocation().distanceTo(this.client.getLocalPlayer().getWorldLocation()) > 12) continue;
            OverlayUtil.renderImageLocation(this.client, graphics, treeObject.getLocalLocation(), this.itemManager.getImage(axe.getItemId()), 120);
        }
        return null;
    }
}

