/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.wiki;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.ObjectComposition;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.wiki.WikiSearchChatboxTextInput;
import net.runelite.client.plugins.wiki.WikiSprite;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.Text;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wiki", description="Adds a Wiki button that takes you to the OSRS Wiki")
public class WikiPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WikiPlugin.class);
    private static final int[] QUESTLIST_WIDGET_IDS = new int[]{WidgetInfo.QUESTLIST_FREE_CONTAINER.getId(), WidgetInfo.QUESTLIST_MEMBERS_CONTAINER.getId(), WidgetInfo.QUESTLIST_MINIQUEST_CONTAINER.getId()};
    static final HttpUrl WIKI_BASE = HttpUrl.parse("https://oldschool.runescape.wiki");
    static final HttpUrl WIKI_API = WIKI_BASE.newBuilder().addPathSegments("api.php").build();
    static final String UTM_SORUCE_KEY = "utm_source";
    static final String UTM_SORUCE_VALUE = "runelite";
    private static final String MENUOP_GUIDE = "Guide";
    private static final String MENUOP_QUICKGUIDE = "Quick Guide";
    private static final String MENUOP_WIKI = "Wiki";
    private static final Pattern SKILL_REGEX = Pattern.compile("([A-Za-z]+) guide");
    private static final Pattern DIARY_REGEX = Pattern.compile("([A-Za-z &]+) Journal");
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Provider<WikiSearchChatboxTextInput> wikiSearchChatboxTextInputProvider;
    private Widget icon;
    private boolean wikiSelected = false;

    @Override
    public void startUp() {
        this.spriteManager.addSpriteOverrides(WikiSprite.values());
        this.clientThread.invokeLater(this::addWidgets);
    }

    @Override
    public void shutDown() {
        this.spriteManager.removeSpriteOverrides(WikiSprite.values());
        this.clientThread.invokeLater(() -> {
            Widget minimapOrbs = this.client.getWidget(WidgetInfo.MINIMAP_ORBS);
            if (minimapOrbs == null) {
                return;
            }
            Widget[] children = minimapOrbs.getChildren();
            if (children == null || children.length < 1) {
                return;
            }
            children[0] = null;
            this.onDeselect();
            this.client.setSpellSelected(false);
        });
    }

    @Subscribe
    private void onWidgetLoaded(WidgetLoaded l) {
        if (l.getGroupId() == 160) {
            this.addWidgets();
        }
    }

    private void addWidgets() {
        Widget minimapOrbs = this.client.getWidget(WidgetInfo.MINIMAP_ORBS);
        if (minimapOrbs == null) {
            return;
        }
        this.icon = minimapOrbs.createChild(0, 5);
        this.icon.setSpriteId(WikiSprite.WIKI_ICON.getSpriteId());
        this.icon.setOriginalX(0);
        this.icon.setOriginalY(2);
        this.icon.setXPositionMode(2);
        this.icon.setYPositionMode(2);
        this.icon.setOriginalWidth(42);
        this.icon.setOriginalHeight(16);
        this.icon.setTargetVerb("Lookup");
        this.icon.setName(MENUOP_WIKI);
        this.icon.setClickMask(47104);
        this.icon.setNoClickThrough(true);
        this.icon.setOnTargetEnterListener(ev -> {
            this.wikiSelected = true;
            this.icon.setSpriteId(WikiSprite.WIKI_SELECTED_ICON.getSpriteId());
        });
        this.icon.setAction(5, "Search");
        this.icon.setOnOpListener(ev -> {
            switch (ev.getOp()) {
                case 6: {
                    this.openSearchInput();
                }
            }
        });
        this.icon.setOnTargetLeaveListener(ev -> this.onDeselect());
        this.icon.revalidate();
    }

    private void onDeselect() {
        this.wikiSelected = false;
        if (this.icon != null) {
            this.icon.setSpriteId(WikiSprite.WIKI_ICON.getSpriteId());
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked ev) {
        if (this.wikiSelected) {
            WorldPoint location;
            String name;
            int id;
            String type;
            this.onDeselect();
            this.client.setSpellSelected(false);
            ev.consume();
            switch (ev.getMenuAction()) {
                case CANCEL: {
                    return;
                }
                case ITEM_USE_ON_WIDGET: 
                case SPELL_CAST_ON_GROUND_ITEM: {
                    type = "item";
                    id = this.itemManager.canonicalize(ev.getId());
                    name = this.itemManager.getItemComposition(id).getName();
                    location = null;
                    break;
                }
                case SPELL_CAST_ON_NPC: {
                    type = "npc";
                    NPC npc = this.client.getCachedNPCs()[ev.getId()];
                    NPCComposition nc = npc.getTransformedComposition();
                    id = nc.getId();
                    name = nc.getName();
                    location = npc.getWorldLocation();
                    break;
                }
                case SPELL_CAST_ON_GAME_OBJECT: {
                    type = "object";
                    ObjectComposition lc = this.client.getObjectDefinition(ev.getId());
                    if (lc.getImpostorIds() != null) {
                        lc = lc.getImpostor();
                    }
                    id = lc.getId();
                    name = lc.getName();
                    location = WorldPoint.fromScene(this.client, ev.getActionParam(), ev.getWidgetId(), this.client.getPlane());
                    break;
                }
                default: {
                    log.info("Unknown menu option: {} {} {}", new Object[]{ev, ev.getMenuAction(), ev.getMenuAction() == MenuAction.CANCEL});
                    return;
                }
            }
            name = Text.removeTags(name);
            HttpUrl.Builder urlBuilder = WIKI_BASE.newBuilder();
            urlBuilder.addPathSegments("w/Special:Lookup").addQueryParameter("type", type).addQueryParameter("id", "" + id).addQueryParameter("name", name).addQueryParameter(UTM_SORUCE_KEY, UTM_SORUCE_VALUE);
            if (location != null) {
                urlBuilder.addQueryParameter("x", "" + location.getX()).addQueryParameter("y", "" + location.getY()).addQueryParameter("plane", "" + location.getPlane());
            }
            HttpUrl url = urlBuilder.build();
            LinkBrowser.browse(url.toString());
            return;
        }
        if (ev.getMenuAction() == MenuAction.RUNELITE) {
            boolean quickguide = false;
            switch (ev.getMenuOption()) {
                case "Quick Guide": {
                    quickguide = true;
                }
                case "Guide": {
                    ev.consume();
                    String quest = Text.removeTags(ev.getMenuTarget());
                    HttpUrl.Builder ub = WIKI_BASE.newBuilder().addPathSegment("w").addPathSegment(quest).addQueryParameter(UTM_SORUCE_KEY, UTM_SORUCE_VALUE);
                    if (quickguide) {
                        ub.addPathSegment("Quick_guide");
                    }
                    LinkBrowser.browse(ub.build().toString());
                    break;
                }
                case "Wiki": {
                    Matcher skillRegex = SKILL_REGEX.matcher(Text.removeTags(ev.getMenuTarget()));
                    Matcher diaryRegex = DIARY_REGEX.matcher(Text.removeTags(ev.getMenuTarget()));
                    if (skillRegex.find()) {
                        LinkBrowser.browse(WIKI_BASE.newBuilder().addPathSegment("w").addPathSegment(skillRegex.group(1)).addQueryParameter(UTM_SORUCE_KEY, UTM_SORUCE_VALUE).build().toString());
                        break;
                    }
                    if (!diaryRegex.find()) break;
                    LinkBrowser.browse(WIKI_BASE.newBuilder().addPathSegment("w").addPathSegment(diaryRegex.group(1) + " Diary").addQueryParameter(UTM_SORUCE_KEY, UTM_SORUCE_VALUE).build().toString());
                }
            }
        }
    }

    private void openSearchInput() {
        this.wikiSearchChatboxTextInputProvider.get().build();
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry menuEntry;
        int widgetIndex = event.getActionParam0();
        int widgetID = event.getActionParam1();
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (Ints.contains(QUESTLIST_WIDGET_IDS, widgetID) && "Read Journal:".equals(event.getOption())) {
            menuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 2);
            MenuEntry menuEntry2 = new MenuEntry();
            menuEntries[menuEntries.length - 1] = menuEntry2;
            menuEntry = menuEntry2;
            menuEntry.setTarget(event.getTarget());
            menuEntry.setOption(MENUOP_GUIDE);
            menuEntry.setParam0(widgetIndex);
            menuEntry.setParam1(widgetID);
            menuEntry.setType(MenuAction.RUNELITE.getId());
            MenuEntry menuEntry3 = new MenuEntry();
            menuEntries[menuEntries.length - 2] = menuEntry3;
            menuEntry = menuEntry3;
            menuEntry.setTarget(event.getTarget());
            menuEntry.setOption(MENUOP_QUICKGUIDE);
            menuEntry.setParam0(widgetIndex);
            menuEntry.setParam1(widgetID);
            menuEntry.setType(MenuAction.RUNELITE.getId());
            this.client.setMenuEntries(menuEntries);
        }
        if (WidgetInfo.TO_GROUP(widgetID) == 320 && event.getOption().startsWith("View") || WidgetInfo.TO_GROUP(widgetID) == 259 && event.getOption().startsWith("Open")) {
            menuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 1);
            MenuEntry menuEntry4 = new MenuEntry();
            menuEntries[menuEntries.length - 1] = menuEntry4;
            menuEntry = menuEntry4;
            menuEntry.setTarget(event.getOption().replace("View ", "").replace("Open ", ""));
            menuEntry.setOption(MENUOP_WIKI);
            menuEntry.setParam0(widgetIndex);
            menuEntry.setParam1(widgetID);
            menuEntry.setIdentifier(event.getIdentifier());
            menuEntry.setType(MenuAction.RUNELITE.getId());
            this.client.setMenuEntries(menuEntries);
        }
    }
}

