/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.wasdcamera;

import com.google.inject.Provides;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IconID;
import net.runelite.api.VarClientInt;
import net.runelite.api.VarClientStr;
import net.runelite.api.Varbits;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.wasdcamera.WASDCameraConfig;
import net.runelite.client.plugins.wasdcamera.WASDCameraListener;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.util.ColorUtil;

@PluginDescriptor(name="WASD Camera", description="Allows use of WASD keys for camera movement with 'Press Enter to Chat'", tags={"enter", "chat"}, enabledByDefault=false)
public class WASDCameraPlugin
extends Plugin {
    private static final String PRESS_ENTER_TO_CHAT = "Press Enter to Chat...";
    private static final String SCRIPT_EVENT_SET_CHATBOX_INPUT = "setChatboxInput";
    private static final String SCRIPT_EVENT_BLOCK_CHAT_INPUT = "blockChatInput";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private KeyManager keyManager;
    @Inject
    private WASDCameraListener inputListener;
    private boolean typing;

    @Override
    protected void startUp() throws Exception {
        this.typing = false;
        this.keyManager.registerKeyListener(this.inputListener);
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.lockChat();
            }
        });
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.unlockChat();
            }
        });
        this.keyManager.unregisterKeyListener(this.inputListener);
    }

    @Provides
    WASDCameraConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(WASDCameraConfig.class);
    }

    boolean chatboxFocused() {
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent == null || chatboxParent.getOnKeyListener() == null) {
            return false;
        }
        Widget worldMapSearch = this.client.getWidget(WidgetInfo.WORLD_MAP_SEARCH);
        return worldMapSearch == null || this.client.getVar(VarClientInt.WORLD_MAP_SEARCH_FOCUSED) != 1;
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        switch (scriptCallbackEvent.getEventName()) {
            case "setChatboxInput": {
                Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
                if (chatboxInput == null || !this.chatboxFocused() || this.typing) break;
                chatboxInput.setText(this.getPlayerNameWithIcon() + ": Press Enter to Chat...");
                break;
            }
            case "blockChatInput": {
                if (this.typing) break;
                int[] intStack = this.client.getIntStack();
                int intStackSize = this.client.getIntStackSize();
                intStack[intStackSize - 1] = 1;
            }
        }
    }

    void lockChat() {
        Widget chatboxInput;
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent != null && chatboxParent.getOnKeyListener() != null && (chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT)) != null) {
            chatboxInput.setText(this.getPlayerNameWithIcon() + ": Press Enter to Chat...");
        }
    }

    void unlockChat() {
        Widget chatboxInput;
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent != null && (chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT)) != null && this.client.getGameState() == GameState.LOGGED_IN) {
            boolean isChatboxTransparent = this.client.isResized() && this.client.getVar(Varbits.TRANSPARENT_CHATBOX) == 1;
            Color textColor = isChatboxTransparent ? JagexColors.CHAT_TYPED_TEXT_TRANSPARENT_BACKGROUND : JagexColors.CHAT_TYPED_TEXT_OPAQUE_BACKGROUND;
            chatboxInput.setText(this.getPlayerNameWithIcon() + ": " + ColorUtil.wrapWithColorTag(this.client.getVar(VarClientStr.CHATBOX_TYPED_TEXT) + "*", textColor));
        }
    }

    private String getPlayerNameWithIcon() {
        IconID icon;
        switch (this.client.getAccountType()) {
            case IRONMAN: {
                icon = IconID.IRONMAN;
                break;
            }
            case ULTIMATE_IRONMAN: {
                icon = IconID.ULTIMATE_IRONMAN;
                break;
            }
            case HARDCORE_IRONMAN: {
                icon = IconID.HARDCORE_IRONMAN;
                break;
            }
            default: {
                return this.client.getLocalPlayer().getName();
            }
        }
        return icon + this.client.getLocalPlayer().getName();
    }

    boolean isTyping() {
        return this.typing;
    }

    void setTyping(boolean typing) {
        this.typing = typing;
    }
}

