/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.wasdcamera;

import com.google.common.base.Strings;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.VarClientStr;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.plugins.wasdcamera.WASDCameraConfig;
import net.runelite.client.plugins.wasdcamera.WASDCameraPlugin;

class WASDCameraListener
extends MouseAdapter
implements KeyListener {
    @Inject
    private WASDCameraPlugin plugin;
    @Inject
    private WASDCameraConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private final Map<Integer, Integer> modified = new HashMap<Integer, Integer>();

    WASDCameraListener() {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.client.getGameState() != GameState.LOGGED_IN || !this.plugin.chatboxFocused()) {
            return;
        }
        if (!this.plugin.isTyping()) {
            if (this.config.up().matches(e)) {
                this.modified.put(e.getKeyCode(), 38);
                e.setKeyCode(38);
            } else if (this.config.down().matches(e)) {
                this.modified.put(e.getKeyCode(), 40);
                e.setKeyCode(40);
            } else if (this.config.left().matches(e)) {
                this.modified.put(e.getKeyCode(), 37);
                e.setKeyCode(37);
            } else if (this.config.right().matches(e)) {
                this.modified.put(e.getKeyCode(), 39);
                e.setKeyCode(39);
            } else {
                switch (e.getKeyCode()) {
                    case 10: 
                    case 47: 
                    case 513: {
                        this.plugin.setTyping(true);
                        this.clientThread.invoke(() -> this.plugin.unlockChat());
                    }
                }
            }
        } else {
            switch (e.getKeyCode()) {
                case 10: {
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(() -> this.plugin.lockChat());
                    break;
                }
                case 27: {
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(() -> {
                        this.client.setVar(VarClientStr.CHATBOX_TYPED_TEXT, "");
                        this.plugin.lockChat();
                    });
                    break;
                }
                case 8: {
                    if (!Strings.isNullOrEmpty(this.client.getVar(VarClientStr.CHATBOX_TYPED_TEXT))) break;
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(() -> this.plugin.lockChat());
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.plugin.chatboxFocused() && !this.plugin.isTyping()) {
            this.modified.remove(e.getKeyCode());
            if (this.config.up().matches(e)) {
                e.setKeyCode(38);
            } else if (this.config.down().matches(e)) {
                e.setKeyCode(40);
            } else if (this.config.left().matches(e)) {
                e.setKeyCode(37);
            } else if (this.config.right().matches(e)) {
                e.setKeyCode(39);
            }
        } else {
            Integer m = this.modified.get(e.getKeyCode());
            if (m != null) {
                this.modified.remove(e.getKeyCode());
                e.setKeyCode(m);
            }
        }
    }
}

