/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.tithefarm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.tithefarm.TitheFarmPlant;
import net.runelite.client.plugins.tithefarm.TitheFarmPlantState;
import net.runelite.client.plugins.tithefarm.TitheFarmPlugin;
import net.runelite.client.plugins.tithefarm.TitheFarmPluginConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;

public class TitheFarmPlantOverlay
extends Overlay {
    private final Client client;
    private final TitheFarmPlugin plugin;
    private final TitheFarmPluginConfig config;
    private final Map<TitheFarmPlantState, Color> borders = new HashMap<TitheFarmPlantState, Color>();
    private final Map<TitheFarmPlantState, Color> fills = new HashMap<TitheFarmPlantState, Color>();

    @Inject
    TitheFarmPlantOverlay(Client client2, TitheFarmPlugin plugin, TitheFarmPluginConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.client = client2;
    }

    public void updateConfig() {
        this.borders.clear();
        this.fills.clear();
        Color colorUnwateredBorder = this.config.getColorUnwatered();
        Color colorUnwatered = new Color(colorUnwateredBorder.getRed(), colorUnwateredBorder.getGreen(), colorUnwateredBorder.getBlue(), 100);
        this.borders.put(TitheFarmPlantState.UNWATERED, colorUnwateredBorder);
        this.fills.put(TitheFarmPlantState.UNWATERED, colorUnwatered);
        Color colorWateredBorder = this.config.getColorWatered();
        Color colorWatered = new Color(colorWateredBorder.getRed(), colorWateredBorder.getGreen(), colorWateredBorder.getBlue(), 100);
        this.borders.put(TitheFarmPlantState.WATERED, colorWateredBorder);
        this.fills.put(TitheFarmPlantState.WATERED, colorWatered);
        Color colorGrownBorder = this.config.getColorGrown();
        Color colorGrown = new Color(colorGrownBorder.getRed(), colorGrownBorder.getGreen(), colorGrownBorder.getBlue(), 100);
        this.borders.put(TitheFarmPlantState.GROWN, colorGrownBorder);
        this.fills.put(TitheFarmPlantState.GROWN, colorGrown);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget viewport = this.client.getViewportWidget();
        for (TitheFarmPlant plant : this.plugin.getPlants()) {
            LocalPoint localLocation;
            if (plant.getState() == TitheFarmPlantState.DEAD || (localLocation = LocalPoint.fromWorld(this.client, plant.getWorldLocation())) == null) continue;
            Point canvasLocation = Perspective.localToCanvas(this.client, localLocation, this.client.getPlane());
            if (viewport == null || canvasLocation == null) continue;
            ProgressPieComponent progressPieComponent = new ProgressPieComponent();
            progressPieComponent.setPosition(canvasLocation);
            progressPieComponent.setProgress(1.0 - plant.getPlantTimeRelative());
            progressPieComponent.setBorderColor(this.borders.get((Object)plant.getState()));
            progressPieComponent.setFill(this.fills.get((Object)plant.getState()));
            progressPieComponent.render(graphics);
        }
        return null;
    }
}

