/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timetracking.farming;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Instant;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.Varbits;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.vars.Autoweed;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.timetracking.SummaryState;
import net.runelite.client.plugins.timetracking.Tab;
import net.runelite.client.plugins.timetracking.TimeTrackingConfig;
import net.runelite.client.plugins.timetracking.farming.FarmingPatch;
import net.runelite.client.plugins.timetracking.farming.FarmingRegion;
import net.runelite.client.plugins.timetracking.farming.FarmingTabPanel;
import net.runelite.client.plugins.timetracking.farming.FarmingWorld;
import net.runelite.client.plugins.timetracking.farming.PatchPrediction;
import net.runelite.client.plugins.timetracking.farming.PatchState;
import net.runelite.client.plugins.timetracking.farming.Produce;

@Singleton
public class FarmingTracker {
    private final Client client;
    private final ItemManager itemManager;
    private final ConfigManager configManager;
    private final TimeTrackingConfig config;
    private final FarmingWorld farmingWorld;
    private final Map<Tab, SummaryState> summaries = new EnumMap<Tab, SummaryState>(Tab.class);
    private final Map<Tab, Long> completionTimes = new EnumMap<Tab, Long>(Tab.class);

    @Inject
    private FarmingTracker(Client client2, ItemManager itemManager, ConfigManager configManager, TimeTrackingConfig config, FarmingWorld farmingWorld) {
        this.client = client2;
        this.itemManager = itemManager;
        this.configManager = configManager;
        this.config = config;
        this.farmingWorld = farmingWorld;
    }

    public FarmingTabPanel createTabPanel(Tab tab) {
        return new FarmingTabPanel(this, this.itemManager, this.config, this.farmingWorld.getTabs().get((Object)tab));
    }

    public boolean updateData(WorldPoint location) {
        FarmingRegion region;
        boolean changed = false;
        String group = "timetracking." + this.client.getUsername();
        String autoweed = Integer.toString(this.client.getVar(Varbits.AUTOWEED));
        if (!autoweed.equals(this.configManager.getConfiguration(group, "autoweed"))) {
            this.configManager.setConfiguration(group, "autoweed", autoweed);
            changed = true;
        }
        if ((region = this.farmingWorld.getRegions().get(location.getRegionID())) != null && region.isInBounds(location)) {
            String group2 = "timetracking." + this.client.getUsername() + "." + region.getRegionID();
            long unixNow = Instant.now().getEpochSecond();
            for (FarmingPatch patch : region.getPatches()) {
                String[] parts;
                Varbits varbit = patch.getVarbit();
                String key = Integer.toString(varbit.getId());
                String strVarbit = Integer.toString(this.client.getVar(varbit));
                String storedValue = this.configManager.getConfiguration(group2, key);
                if (storedValue != null && (parts = storedValue.split(":")).length == 2 && parts[0].equals(strVarbit)) {
                    long unixTime = 0L;
                    try {
                        unixTime = Long.parseLong(parts[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (unixTime + 300L > unixNow && unixNow + 30L > unixTime) continue;
                }
                String value = strVarbit + ":" + unixNow;
                this.configManager.setConfiguration(group2, key, value);
                changed = true;
            }
        }
        if (changed) {
            this.updateCompletionTime();
        }
        return changed;
    }

    @Nullable
    public PatchPrediction predictPatch(FarmingPatch patch) {
        String key;
        long unixNow = Instant.now().getEpochSecond();
        String group = "timetracking." + this.client.getUsername();
        boolean autoweed = Integer.toString(Autoweed.ON.ordinal()).equals(this.configManager.getConfiguration(group, "autoweed"));
        group = "timetracking." + this.client.getUsername() + "." + patch.getRegion().getRegionID();
        String storedValue = this.configManager.getConfiguration(group, key = Integer.toString(patch.getVarbit().getId()));
        if (storedValue == null) {
            return null;
        }
        long unixTime = 0L;
        int value = 0;
        String[] parts = storedValue.split(":");
        if (parts.length == 2) {
            try {
                value = Integer.parseInt(parts[0]);
                unixTime = Long.parseLong(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (unixTime <= 0L) {
            return null;
        }
        PatchState state = patch.getImplementation().forVarbitValue(value);
        int stage = state.getStage();
        int stages = state.getStages();
        int tickrate = state.getTickRate() * 60;
        if (autoweed && state.getProduce() == Produce.WEEDS) {
            stage = 0;
            stages = 1;
            tickrate = 0;
        }
        long doneEstimate = 0L;
        if (tickrate > 0) {
            long tickNow = (unixNow + 300L) / (long)tickrate;
            long tickTime = (unixTime + 300L) / (long)tickrate;
            int delta = (int)(tickNow - tickTime);
            doneEstimate = ((long)(stages - 1 - stage) + tickTime) * (long)tickrate + 300L;
            if ((stage += delta) >= stages) {
                stage = stages - 1;
            }
        }
        return new PatchPrediction(state.getProduce(), state.getCropState(), doneEstimate, stage, stages);
    }

    public void loadCompletionTimes() {
        this.summaries.clear();
        this.completionTimes.clear();
        this.updateCompletionTime();
    }

    public SummaryState getSummary(Tab patchType) {
        SummaryState summary = this.summaries.get((Object)patchType);
        return summary == null ? SummaryState.UNKNOWN : summary;
    }

    public long getCompletionTime(Tab patchType) {
        Long completionTime = this.completionTimes.get((Object)patchType);
        return completionTime == null ? -1L : completionTime;
    }

    private void updateCompletionTime() {
        for (Map.Entry<Tab, Set<FarmingPatch>> tab : this.farmingWorld.getTabs().entrySet()) {
            long completionTime;
            SummaryState state;
            long maxCompletionTime = 0L;
            boolean allUnknown = true;
            boolean allEmpty = true;
            for (FarmingPatch patch : tab.getValue()) {
                PatchPrediction prediction = this.predictPatch(patch);
                if (prediction == null || prediction.getProduce().getItemID() < 0) continue;
                allUnknown = false;
                if (prediction.getProduce() == Produce.WEEDS || prediction.getProduce() == Produce.SCARECROW) continue;
                allEmpty = false;
                maxCompletionTime = Math.max(maxCompletionTime, prediction.getDoneEstimate());
            }
            if (allUnknown) {
                state = SummaryState.UNKNOWN;
                completionTime = -1L;
            } else if (allEmpty) {
                state = SummaryState.EMPTY;
                completionTime = -1L;
            } else if (maxCompletionTime <= Instant.now().getEpochSecond()) {
                state = SummaryState.COMPLETED;
                completionTime = 0L;
            } else {
                state = SummaryState.IN_PROGRESS;
                completionTime = maxCompletionTime;
            }
            this.summaries.put(tab.getKey(), state);
            this.completionTimes.put(tab.getKey(), completionTime);
        }
    }
}

