/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timetracking.farming;

import com.google.common.base.Strings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.timetracking.TabContentPanel;
import net.runelite.client.plugins.timetracking.TimeTrackingConfig;
import net.runelite.client.plugins.timetracking.TimeablePanel;
import net.runelite.client.plugins.timetracking.farming.FarmingPatch;
import net.runelite.client.plugins.timetracking.farming.FarmingTracker;
import net.runelite.client.plugins.timetracking.farming.PatchImplementation;
import net.runelite.client.plugins.timetracking.farming.PatchPrediction;
import net.runelite.client.plugins.timetracking.farming.Produce;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmingTabPanel
extends TabContentPanel {
    private static final Logger log = LoggerFactory.getLogger(FarmingTabPanel.class);
    private final FarmingTracker farmingTracker;
    private final ItemManager itemManager;
    private final TimeTrackingConfig config;
    private final List<TimeablePanel<FarmingPatch>> patchPanels;

    FarmingTabPanel(FarmingTracker farmingTracker, ItemManager itemManager, TimeTrackingConfig config, Set<FarmingPatch> patches) {
        this.farmingTracker = farmingTracker;
        this.itemManager = itemManager;
        this.config = config;
        this.patchPanels = new ArrayList<TimeablePanel<FarmingPatch>>();
        this.setLayout(new GridBagLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        PatchImplementation lastImpl = null;
        boolean first = true;
        for (FarmingPatch patch : patches) {
            String title = patch.getRegion().getName() + (String)(Strings.isNullOrEmpty(patch.getName()) ? "" : " (" + patch.getName() + ")");
            TimeablePanel<FarmingPatch> p = new TimeablePanel<FarmingPatch>(patch, title, 1);
            if (patch.getImplementation() != lastImpl && !Strings.isNullOrEmpty(patch.getImplementation().getName())) {
                JLabel groupLabel = new JLabel(patch.getImplementation().getName());
                if (first) {
                    first = false;
                    groupLabel.setBorder(new EmptyBorder(4, 0, 0, 0));
                } else {
                    groupLabel.setBorder(new EmptyBorder(15, 0, 0, 0));
                }
                groupLabel.setFont(FontManager.getRunescapeSmallFont());
                this.add((Component)groupLabel, c);
                ++c.gridy;
                lastImpl = patch.getImplementation();
            }
            this.patchPanels.add(p);
            this.add(p, c);
            ++c.gridy;
            if (!first) continue;
            first = false;
            p.setBorder(null);
        }
    }

    @Override
    public int getUpdateInterval() {
        return 50;
    }

    @Override
    public void update() {
        long unixNow = Instant.now().getEpochSecond();
        for (TimeablePanel<FarmingPatch> panel : this.patchPanels) {
            FarmingPatch patch = panel.getTimeable();
            PatchPrediction prediction = this.farmingTracker.predictPatch(patch);
            if (prediction == null) {
                this.itemManager.getImage(Produce.WEEDS.getItemID()).addTo(panel.getIcon());
                panel.getIcon().setToolTipText("Unknown state");
                panel.getProgress().setMaximumValue(0);
                panel.getProgress().setValue(0);
                panel.getProgress().setVisible(false);
                panel.getEstimate().setText("Unknown");
                panel.getProgress().setBackground(null);
                continue;
            }
            if (prediction.getProduce().getItemID() < 0) {
                panel.getIcon().setIcon(null);
                panel.getIcon().setToolTipText("Unknown state");
            } else {
                this.itemManager.getImage(prediction.getProduce().getItemID()).addTo(panel.getIcon());
                panel.getIcon().setToolTipText(prediction.getProduce().getName());
            }
            switch (prediction.getCropState()) {
                case HARVESTABLE: {
                    panel.getEstimate().setText("Done");
                    break;
                }
                case GROWING: {
                    if (prediction.getDoneEstimate() < unixNow) {
                        panel.getEstimate().setText("Done");
                        break;
                    }
                    panel.getEstimate().setText("Done " + FarmingTabPanel.getFormattedEstimate(prediction.getDoneEstimate() - unixNow, this.config.estimateRelative()));
                    break;
                }
                case DISEASED: {
                    panel.getEstimate().setText("Diseased");
                    break;
                }
                case DEAD: {
                    panel.getEstimate().setText("Dead");
                }
            }
            if (prediction.getProduce() != Produce.WEEDS || prediction.getStage() < prediction.getStages() - 1) {
                panel.getProgress().setVisible(true);
                panel.getProgress().setForeground(prediction.getCropState().getColor().darker());
                panel.getProgress().setMaximumValue(prediction.getStages() - 1);
                panel.getProgress().setValue(prediction.getStage());
                continue;
            }
            panel.getProgress().setVisible(false);
        }
    }
}

