/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timetracking.clocks;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import joptsimple.internal.Strings;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.timetracking.TimeTrackingConfig;
import net.runelite.client.plugins.timetracking.clocks.Clock;
import net.runelite.client.plugins.timetracking.clocks.ClockTabPanel;
import net.runelite.client.plugins.timetracking.clocks.Stopwatch;
import net.runelite.client.plugins.timetracking.clocks.Timer;

@Singleton
public class ClockManager {
    @Inject
    private ConfigManager configManager;
    @Inject
    private TimeTrackingConfig config;
    @Inject
    private Notifier notifier;
    private final List<Timer> timers = new CopyOnWriteArrayList<Timer>();
    private final List<Stopwatch> stopwatches = new ArrayList<Stopwatch>();
    private ClockTabPanel clockTabPanel = new ClockTabPanel(this);

    void addTimer() {
        this.timers.add(new Timer("Timer " + (this.timers.size() + 1), (long)(this.config.defaultTimerMinutes() * 60)));
        this.saveTimers();
        SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
    }

    void addStopwatch() {
        this.stopwatches.add(new Stopwatch("Stopwatch " + (this.stopwatches.size() + 1)));
        this.saveStopwatches();
        SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
    }

    void removeTimer(Timer timer) {
        this.timers.remove(timer);
        this.saveTimers();
        SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
    }

    void removeStopwatch(Stopwatch stopwatch) {
        this.stopwatches.remove(stopwatch);
        this.saveStopwatches();
        SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
    }

    public long getActiveTimerCount() {
        return this.timers.stream().filter(Clock::isActive).count();
    }

    public long getActiveStopwatchCount() {
        return this.stopwatches.stream().filter(Clock::isActive).count();
    }

    public boolean checkCompletion() {
        boolean changed = false;
        for (Timer timer : this.timers) {
            if (!timer.isActive() || timer.getDisplayTime() != 0L) continue;
            timer.pause();
            changed = true;
            if (!this.config.timerNotification()) continue;
            this.notifier.notify("[" + timer.getName() + "] has finished counting down.");
        }
        if (changed) {
            this.saveTimers();
            SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
        }
        return changed;
    }

    public void loadTimers() {
        String timersJson = this.configManager.getConfiguration("timetracking", "timers");
        if (!Strings.isNullOrEmpty(timersJson)) {
            Gson gson = new Gson();
            List timers = (List)gson.fromJson(timersJson, new TypeToken<ArrayList<Timer>>(){}.getType());
            this.timers.clear();
            this.timers.addAll(timers);
            SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
        }
    }

    public void loadStopwatches() {
        String stopwatchesJson = this.configManager.getConfiguration("timetracking", "stopwatches");
        if (!Strings.isNullOrEmpty(stopwatchesJson)) {
            Gson gson = new Gson();
            List stopwatches = (List)gson.fromJson(stopwatchesJson, new TypeToken<ArrayList<Stopwatch>>(){}.getType());
            this.stopwatches.clear();
            this.stopwatches.addAll(stopwatches);
            SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
        }
    }

    public void clear() {
        this.timers.clear();
        this.stopwatches.clear();
        SwingUtilities.invokeLater(this.clockTabPanel::rebuild);
    }

    void saveToConfig() {
        this.saveTimers();
        this.saveStopwatches();
    }

    void saveTimers() {
        Gson gson = new Gson();
        String json = gson.toJson(this.timers);
        this.configManager.setConfiguration("timetracking", "timers", json);
    }

    void saveStopwatches() {
        Gson gson = new Gson();
        String json = gson.toJson(this.stopwatches);
        this.configManager.setConfiguration("timetracking", "stopwatches", json);
    }

    public List<Timer> getTimers() {
        return this.timers;
    }

    public List<Stopwatch> getStopwatches() {
        return this.stopwatches;
    }

    public ClockTabPanel getClockTabPanel() {
        return this.clockTabPanel;
    }
}

