/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timetracking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.ThinProgressBar;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;

public class TimeablePanel<T>
extends JPanel {
    private final T timeable;
    private final JLabel icon = new JLabel();
    private final JLabel estimate = new JLabel();
    private final ThinProgressBar progress = new ThinProgressBar();

    public TimeablePanel(T timeable, String title, int maximumProgressValue) {
        this.timeable = timeable;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(7, 0, 0, 0));
        JPanel topContainer = new JPanel();
        topContainer.setBorder(new EmptyBorder(7, 7, 6, 0));
        topContainer.setLayout(new BorderLayout());
        topContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.icon.setMinimumSize(new Dimension(36, 32));
        JPanel infoPanel = new JPanel();
        infoPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        infoPanel.setLayout(new GridLayout(2, 1));
        infoPanel.setBorder(new EmptyBorder(4, 4, 4, 0));
        JShadowedLabel location = new JShadowedLabel(title);
        location.setFont(FontManager.getRunescapeSmallFont());
        location.setForeground(Color.WHITE);
        this.estimate.setFont(FontManager.getRunescapeSmallFont());
        this.estimate.setForeground(Color.GRAY);
        infoPanel.add(location);
        infoPanel.add(this.estimate);
        topContainer.add((Component)this.icon, "West");
        topContainer.add((Component)infoPanel, "Center");
        this.progress.setValue(0);
        this.progress.setMaximumValue(maximumProgressValue);
        this.add((Component)topContainer, "North");
        this.add((Component)this.progress, "South");
    }

    public T getTimeable() {
        return this.timeable;
    }

    public JLabel getIcon() {
        return this.icon;
    }

    public JLabel getEstimate() {
        return this.estimate;
    }

    public ThinProgressBar getProgress() {
        return this.progress;
    }
}

