/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timetracking;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.timetracking.TimeTrackingConfig;
import net.runelite.client.plugins.timetracking.TimeTrackingPanel;
import net.runelite.client.plugins.timetracking.clocks.ClockManager;
import net.runelite.client.plugins.timetracking.farming.FarmingTracker;
import net.runelite.client.plugins.timetracking.hunter.BirdHouseTracker;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Time Tracking", description="Enable the Time Tracking panel, which contains timers, stopwatches, and farming and bird house trackers", tags={"birdhouse", "farming", "hunter", "notifications", "skilling", "stopwatches", "timers", "panel"})
public class TimeTrackingPlugin
extends Plugin {
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private FarmingTracker farmingTracker;
    @Inject
    private BirdHouseTracker birdHouseTracker;
    @Inject
    private ClockManager clockManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TimeTrackingConfig config;
    @Inject
    private ScheduledExecutorService executorService;
    private ScheduledFuture panelUpdateFuture;
    private TimeTrackingPanel panel;
    private NavigationButton navButton;
    private WorldPoint lastTickLocation;
    private boolean lastTickPostLogin;

    @Provides
    TimeTrackingConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(TimeTrackingConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.clockManager.loadTimers();
        this.clockManager.loadStopwatches();
        this.birdHouseTracker.loadFromConfig();
        this.farmingTracker.loadCompletionTimes();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "watch.png");
        this.panel = new TimeTrackingPanel(this.itemManager, this.config, this.farmingTracker, this.birdHouseTracker, this.clockManager);
        this.navButton = NavigationButton.builder().tooltip("Time Tracking").icon(icon).panel(this.panel).priority(4).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.panelUpdateFuture = this.executorService.scheduleAtFixedRate(this::updatePanel, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void shutDown() throws Exception {
        this.lastTickLocation = null;
        this.lastTickPostLogin = false;
        if (this.panelUpdateFuture != null) {
            this.panelUpdateFuture.cancel(true);
            this.panelUpdateFuture = null;
        }
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("timetracking")) {
            return;
        }
        if (this.clockManager.getTimers().isEmpty() && e.getKey().equals("timers")) {
            this.clockManager.loadTimers();
        } else if (this.clockManager.getStopwatches().isEmpty() && e.getKey().equals("stopwatches")) {
            this.clockManager.loadStopwatches();
        }
    }

    @Subscribe
    public void onGameTick(GameTick t) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.lastTickLocation = null;
            return;
        }
        Widget motd = this.client.getWidget(WidgetInfo.LOGIN_CLICK_TO_PLAY_SCREEN_MESSAGE_OF_THE_DAY);
        if (motd != null && !motd.isHidden()) {
            this.lastTickPostLogin = true;
            return;
        }
        if (this.lastTickPostLogin) {
            this.lastTickPostLogin = false;
            return;
        }
        WorldPoint loc = this.lastTickLocation;
        this.lastTickLocation = this.client.getLocalPlayer().getWorldLocation();
        if (loc == null || loc.getRegionID() != this.lastTickLocation.getRegionID()) {
            return;
        }
        boolean birdHouseDataChanged = this.birdHouseTracker.updateData(loc);
        boolean farmingDataChanged = this.farmingTracker.updateData(loc);
        if (birdHouseDataChanged || farmingDataChanged) {
            this.panel.update();
        }
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged e) {
        this.farmingTracker.loadCompletionTimes();
        this.birdHouseTracker.loadFromConfig();
        this.panel.update();
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS)
    public void checkCompletion() {
        boolean birdHouseDataChanged = this.birdHouseTracker.checkCompletion();
        if (birdHouseDataChanged) {
            this.panel.update();
        }
    }

    private void updatePanel() {
        long unitTime = Instant.now().toEpochMilli() / 200L;
        boolean clockDataChanged = false;
        if (unitTime % 5L == 0L) {
            clockDataChanged = this.clockManager.checkCompletion();
        }
        if (unitTime % (long)this.panel.getUpdateInterval() == 0L || clockDataChanged) {
            this.panel.update();
        }
    }
}

