/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timetracking;

import java.awt.Dimension;
import java.time.LocalDateTime;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import javax.swing.JPanel;

public abstract class TabContentPanel
extends JPanel {
    public abstract int getUpdateInterval();

    public abstract void update();

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    protected static String getFormattedEstimate(long remainingSeconds, boolean useRelativeTime) {
        if (useRelativeTime) {
            StringBuilder sb = new StringBuilder("in ");
            long duration = (remainingSeconds + 59L) / 60L;
            long minutes = duration % 60L;
            long hours = duration / 60L % 24L;
            long days = duration / 1440L;
            if (days > 0L) {
                sb.append(days).append("d ");
            }
            if (hours > 0L) {
                sb.append(hours).append("h ");
            }
            if (minutes > 0L) {
                sb.append(minutes).append("m ");
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        LocalDateTime endTime = LocalDateTime.now().plus(remainingSeconds, ChronoUnit.SECONDS);
        LocalDateTime currentTime = LocalDateTime.now();
        if (endTime.getDayOfWeek() != currentTime.getDayOfWeek()) {
            sb.append(endTime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault())).append(" ");
        }
        sb.append(String.format("at %d:%02d", endTime.getHour(), endTime.getMinute()));
        return sb.toString();
    }
}

