/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timetracking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.timetracking.Tab;
import net.runelite.client.plugins.timetracking.TimeTrackingPanel;
import net.runelite.client.plugins.timetracking.TimeTrackingPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

class OverviewItemPanel
extends JPanel {
    private static final ImageIcon ARROW_RIGHT_ICON;
    private static final Color HOVER_COLOR;
    private final JLabel statusLabel;

    OverviewItemPanel(ItemManager itemManager, final TimeTrackingPanel pluginPanel, final Tab tab, String title) {
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(7, 7, 7, 7));
        JLabel iconLabel = new JLabel();
        iconLabel.setMinimumSize(new Dimension(36, 32));
        itemManager.getImage(tab.getItemID()).addTo(iconLabel);
        this.add((Component)iconLabel, "West");
        final JPanel textContainer = new JPanel();
        textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        textContainer.setLayout(new GridLayout(2, 1));
        textContainer.setBorder(new EmptyBorder(5, 7, 5, 7));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                pluginPanel.switchTab(tab);
                OverviewItemPanel.this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OverviewItemPanel.this.setBackground(HOVER_COLOR);
                textContainer.setBackground(HOVER_COLOR);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OverviewItemPanel.this.setBackground(HOVER_COLOR);
                textContainer.setBackground(HOVER_COLOR);
                OverviewItemPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OverviewItemPanel.this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                OverviewItemPanel.this.setCursor(new Cursor(0));
            }
        });
        JLabel titleLabel = new JLabel(title);
        titleLabel.setForeground(Color.WHITE);
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.statusLabel = new JLabel();
        this.statusLabel.setForeground(Color.GRAY);
        this.statusLabel.setFont(FontManager.getRunescapeSmallFont());
        textContainer.add(titleLabel);
        textContainer.add(this.statusLabel);
        this.add((Component)textContainer, "Center");
        JLabel arrowLabel = new JLabel(ARROW_RIGHT_ICON);
        this.add((Component)arrowLabel, "East");
    }

    void updateStatus(String text, Color color) {
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(color);
    }

    static {
        HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
        ARROW_RIGHT_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(TimeTrackingPlugin.class, "/util/arrow_right.png"));
    }
}

