/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timestamp;

import com.google.inject.Provides;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.Varbits;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.timestamp.TimestampConfig;
import net.runelite.client.util.ColorUtil;

@PluginDescriptor(name="Chat Timestamps", description="Add timestamps to chat messages", tags={"timestamp"}, enabledByDefault=false)
public class TimestampPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private TimestampConfig config;
    private SimpleDateFormat formatter;

    @Provides
    public TimestampConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(TimestampConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.updateFormatter();
    }

    @Override
    protected void shutDown() throws Exception {
        this.formatter = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("timestamp") && event.getKey().equals("format")) {
            this.updateFormatter();
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("addTimestamp")) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        int messageId = intStack[intStackSize - 1];
        MessageNode messageNode = (MessageNode)((Object)this.client.getMessages().get(messageId));
        Object timestamp = this.generateTimestamp(messageNode.getTimestamp(), ZoneId.systemDefault()) + " ";
        Color timestampColour = this.getTimestampColour();
        if (timestampColour != null) {
            timestamp = ColorUtil.wrapWithColorTag((String)timestamp, timestampColour);
        }
        stringStack[stringStackSize - 1] = timestamp;
    }

    private Color getTimestampColour() {
        boolean isChatboxTransparent = this.client.isResized() && this.client.getVar(Varbits.TRANSPARENT_CHATBOX) == 1;
        return isChatboxTransparent ? this.config.transparentTimestamp() : this.config.opaqueTimestamp();
    }

    String generateTimestamp(int timestamp, ZoneId zoneId) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), zoneId);
        return this.formatter.format(Date.from(time.toInstant()));
    }

    private void updateFormatter() {
        try {
            this.formatter = new SimpleDateFormat(this.config.timestampFormat());
        }
        catch (IllegalArgumentException e) {
            this.formatter = new SimpleDateFormat("[HH:mm]");
        }
    }

    public SimpleDateFormat getFormatter() {
        return this.formatter;
    }
}

